#
#  Makefile for ECM_blinky.o
#
#  You can run this makefile from the command line with:
#
#  cs-make -f ECM_blinky.mak           or
#  cs-make -f ECM_blinky.mak clean
#
#  Make sure the CodeSourcery cs-make.exe is in your
#  execution path.
#

#  Project Name
PROJECT = ECM_blinky

#  List of the objects files to be compiled/assembled
OBJECTS = $(PROJECT).o

#  This project does not create an executable, so it does
#  not use a linker script.
LSCRIPT = 

#  List of directories to be included during compilation
INCDIRS = ..\include

#  List of additional object modules to link in.
#  Use this variable to point to prebuilt object modules
#  that exist outside of a library (such as the startup
#  code).
ADDOBJS = 

OPTIMIZATION = 0
DEBUG = -g
ASLISTING = -alhs
LIBDIRS = 
LIBS = 


#  Compiler Options
GCFLAGS = -Wall -fno-common -mcpu=cortex-m3 -mthumb -O$(OPTIMIZATION) $(DEBUG)
GCFLAGS += -I$(INCDIRS)
#GCFLAGS += -Wcast-align -Wcast-qual -Wimplicit -Wpointer-arith -Wswitch
#GCFLAGS += -Wredundant-decls -Wreturn-type -Wshadow -Wunused
LDFLAGS = -mcpu=cortex-m3 -mthumb -O$(OPTIMIZATION) -nostartfiles -Wl,-Map=$(PROJECT).map -T$(LSCRIPT)
LDFLAGS += -L$(LIBDIRS)
LDFLAGS += -l$(LIBS)

ASFLAGS = $(ASLISTING) -mcpu=cortex-m3

#  Compiler/Assembler/Linker Paths
GCC = arm-none-eabi-gcc
AS = arm-none-eabi-as
LD = arm-none-eabi-ld
OBJCOPY = arm-none-eabi-objcopy
REMOVE = rm -f
SIZE = arm-none-eabi-size

#########################################################################

all:: $(PROJECT).o

clean:
	$(REMOVE) $(OBJECTS)
	$(REMOVE) *.lst

#########################################################################
#  Default rules to compile .c and .cpp file to .o
#  and assemble .s files to .o

.c.o :
	$(GCC) $(GCFLAGS) -c $<

.cpp.o :
	$(GCC) $(GCFLAGS) -c $<

.s.o :
	$(AS) $(ASFLAGS) -o $@ $< > $(basename $@).lst

#########################################################################
