/*
 *  syscalls.h
 *
 *  This header file provides prototypes for the newlib stub functions
 *  you will need to provide if you want to use the C functions standard
 *  on most "real" operating systems.
 *
 *  This is only needed if you are trying to write C programs that use
 *  system utilities (such as printf) on "bare-metal" systems.
 *
 *  For an excellent explanation on this concept, along with some working
 *  examples, refer to: http://eetimes.com/discussion/guest-editor/4023922/Embedding-GNU-Newlib-Part-2
 *
 */

#ifndef  SYSCALLS_H
#define  SYSCALLS_H


#include "LPC17xx.h"
#include <errno.h>
#include <sys/times.h>
#include <sys/stat.h>
#include <sys/unistd.h>
#include <stdint.h>
#include "uart.h"



/*
 *  Define a structure for the device operations table, used to hold device
 *  descriptors for the different stream devices supported.
 */
typedef struct  devoptab_t
{
   const char				*name;			// string containing the name of the device ("stdin" or "COM1")
   int						(*open)(const char *path, int flags, int mode);
   int						(*close)(int fd);
   long						(*write) (int fd, const char *ptr, int len);
   long						(*read)(int fd, char *ptr, int len);
   int						(*avail)(int fd);				// returns number of chars available in stream
}  DEVOPTAB;







int 			_write(int fd, char *ptr, int len);		// used by printf and others to write chars to I/O
int				_open(const char  *file, int  flags, int  mode);
int 			_close(int fd);
int				_execve(char *name, char **argv, char **env);
int				_fork();
int				_fstat(int fd, struct stat *st);
int				_getpid();
int				_isatty(int fd);
int				_kill(int pid, int sig);
int				_link(char *old, char *new);
int				_lseek(int fd, int ptr, int dir);
caddr_t			_sbrk(int incr);
int				_read(int fd, char *ptr, int len);
int				_stat(const char *filepath, struct stat *st);
clock_t			_times(struct tms *buf);
int				_unlink(char *name);
int				_wait(int *status);


/*
 *  Custom routines added by Karl Lunt.
 */
int				_avail(int  fd);
int				set_stdio(int  fd, int  uartn);



#endif
