/*
 *  term_io.h      header file for clones of several essential terminal I/O routines
 *
 *  These routines were taken from Martin Thomas' website; he used them
 *  in an STM project.  See http://gandalf.arubi.uni-kl.de/avr_projects/arm_projects/index_cortex.html.
 *
 *  I have made slight modifications for my UART libraries, which use the newlib
 *  libraries.  The only part of the newlib code I don't have working properly is
 *  some part inside iprintf.
 *
 *  Karl Lunt, 26 Dec 2011
 */
 
// Basic code from ChaN, minor modifications by Martin Thomas

#ifndef TERM_IO_H
#define TERM_IO_H

#ifdef __cplusplus
 extern "C" {
#endif

//#define xgetc() (char)comm_get()
//#define xavail() comm_test()
uint8_t					xgetc(void);
int						xavail(void);
int						xatoi(char**, long*);
void					xputc(char);
void					xputs(const char*);
void					xitoa(long, int, int);
void					xprintf(const char*, ...) __attribute__ ((format (__printf__, 1, 2)));
void					put_dump(const uint8_t*, uint32_t ofs, int cnt);
void					get_line(char*, int len);
int						get_line_r(char*, int len, int *idx);

#ifdef __cplusplus
 }
#endif

#endif /* TERM_IO_H */
