#!/bin/bash

#export DIALOGRC=~/dialog.rc

#WARNING: This script MUST be sourced.
#If buffer is missing, we need to bootstrap, because script is not 
# sourced.
if [ "${BUFFER}" = "" ]; then
	echo ERROR! No buffer, bootstrapping!
	source ./bootstrap.sh
fi
#Hide buffer
#TITLE=$TITLE2"                                Scanner Operation"

PORTS=$(gphoto2 --list-ports | grep usb)
#PORTS=$(gphoto2 --list-ports)
DIALOG --title "Select camera" \
--inputbox "These are USB PTP cameras in your system:\n \
$PORTS\n\nType two numbers of cameras separated by spaces.\nE.g. \
003 002 if we have usb:001,003 and usb:001,002 cameras. \n" 20 70 \
2>/tmp/cams.tmp
#user aborts
if [ ! -s "/tmp/cams.tmp" ]; then
	source ./M.sh
fi
#Camera descriptors
CAM1=$(cat /tmp/cams.tmp | awk '{ print $1 }')
CAM1="usb:001,"$CAM1
CAM2=$(cat /tmp/cams.tmp | awk '{ print $2 }')
CAM2="usb:001,"$CAM2

I="1"
while :
do
	K=$(DIALOG --nocancel --title "Scanning operation" \
	--menu "Taking photo: $I\n " 11 25 3 \
	t "Take" d "Develop" a "Abort" 2>&1 >/dev/tty)
	if [ "${K}" = "a" ]; then
		#abort
		#source ./M.sh
		return
	fi
	if [ "${K}" = "d" ]; then
		#develop
		source ./acquire.sh
		return
	fi

	echo "..."
	gphoto2 --quiet --port "$CAM1" --capture-image &
	gphoto2 --quiet --port "$CAM2" --capture-image &
	wait
	beep
	I=$[$I+1]
done

