#ifndef __GALPROTO_SEP_20_2000
#define __GALPROTO_SEP_20_2000

typedef unsigned int    DWORD;
typedef unsigned short  WORD;
typedef unsigned char   CHAR;
typedef unsigned char   BOOLEAN;

typedef unsigned int    *PDWORD;

typedef struct __GALAPP_ADAPTERINFO
{
    DWORD  dwCPUVersion;
    DWORD  dwFrameBufferBase;
    DWORD  dwFrameBufferSize;
    DWORD  dwGfxRegisterBase;
    DWORD  dwVidRegisterSize;
    DWORD  dwVipRegisterBase;
    DWORD  dwVideoVersion;
} GALAPP_ADAPTERINFO, *PGALAPP_ADAPTERINFO;

typedef struct __GALAPP_DISPLAYTIMING
{
    DWORD  dwDotClock;
    WORD   wPitch;
    WORD   wBpp;
    WORD   wHTotal;
    WORD   wHActive;
    WORD   wHSyncStart;
    WORD   wHSyncEnd;
    WORD   wHBlankStart;
    WORD   wHBlankEnd;
    WORD   wVTotal;
    WORD   wVActive;
    WORD   wVSyncStart;
    WORD   wVSyncEnd;
    WORD   wVBlankStart;
    WORD   wVBlankEnd;
    WORD   wPolarity;
} GALAPP_DISPLAYTIMING, *PGALAPP_DISPLAYTIMING;

/* Gotta find a way out for this.
 * This should match durango defs
 */
#define STD_CRTC_REGS 25
#define EXT_CRTC_REGS 16
#define VGA_FLAG_MISC_OUTPUT	0x00000001
#define VGA_FLAG_STD_CRTC		0x00000002
#define VGA_FLAG_EXT_CRTC		0x00000004
typedef struct __GALAPP_VGAREGS
{
    int xsize;
    int ysize;
    int hz;
    int clock;
    unsigned char miscOutput;
    unsigned char stdCRTCregs[STD_CRTC_REGS];
    unsigned char extCRTCregs[EXT_CRTC_REGS];
} GALAPP_VGAREGS, *PGALAPP_VGAREGS;

typedef struct __GALAPP_PALETTE
{
    DWORD dwColors[256];
} GALAPP_PALETTE, *PGALAPP_PALETTE;

#define GAL_SOFTVGASTATE_ENABLE   1
#define GAL_SOFTVGASTATE_DISABLE  0

#define GAL_SETCURSORENABLE_ENABLE    1
#define GAL_SETCURSORENABLE_DISABLE   0

#define GAL_COMPRESSION_ENABLE   1
#define GAL_COMPRESSION_DISABLE  0

#define GAL_COMPRESSION_OFFSET  1
#define GAL_COMPRESSION_PITCH   2
#define GAL_COMPRESSION_SIZE    4
#define GAL_COMPRESSION_ALL     7

BOOLEAN Gal_initialize_interface(void);
BOOLEAN Gal_cleanup_interface(void);

BOOLEAN Gal_get_adapter_info(GALAPP_ADAPTERINFO *);
BOOLEAN Gal_set_softvga_state(BOOLEAN);
BOOLEAN Gal_wait_until_idle(void);
BOOLEAN Gal_wait_vertical_blank(void);

BOOLEAN Gal_is_display_mode_supported(int xres, int yres, int bpp, int hz, int *supported);
BOOLEAN Gal_set_display_mode(int xres, int yres, int bpp, int hz);
BOOLEAN Gal_get_display_mode(int *xres, int *yres, int *bpp, int *hz);
BOOLEAN Gal_set_display_bpp(unsigned short bpp);
BOOLEAN Gal_get_display_bpp(unsigned short *bpp);
BOOLEAN Gal_set_display_pitch(unsigned short pitch);
BOOLEAN Gal_get_display_pitch(unsigned short *pitch);
BOOLEAN Gal_set_display_offset(unsigned long offset);
BOOLEAN Gal_get_display_offset(unsigned long *offset);
BOOLEAN Gal_get_refreshrate_from_dotclock(int xres, int yres, int bpp, 
                                       int *hz, unsigned long frequency);
BOOLEAN Gal_get_display_timing(PGALAPP_DISPLAYTIMING);
BOOLEAN Gal_set_display_timing(PGALAPP_DISPLAYTIMING);
BOOLEAN Gal_set_display_palette(PGALAPP_PALETTE);

BOOLEAN Gal_set_cursor_enable(int enable);
BOOLEAN Gal_set_cursor_colors(unsigned long bkcolor, unsigned long fgcolor);
BOOLEAN Gal_set_cursor_position(unsigned long memoffset, 
                             unsigned short xpos, unsigned short ypos, 
                             unsigned short xhotspot, unsigned short yhotspot);
BOOLEAN Gal_set_cursor_shape32(unsigned long memoffset, 
                            unsigned long *andmask, unsigned long *xormask);

BOOLEAN Gal_set_solid_pattern(unsigned long color);
BOOLEAN Gal_set_mono_pattern(unsigned long bgcolor, unsigned long fgcolor, 
                          unsigned long data0, unsigned long data1, 
                         unsigned char transparency);
BOOLEAN Gal_set_raster_operation(unsigned char rop);
BOOLEAN Gal_pattern_fill(unsigned short x, unsigned short y, 
	unsigned short width, unsigned short height);
BOOLEAN Gal_set_solid_source(unsigned long color);
BOOLEAN Gal_screen_to_screen_blt(unsigned short srcx, unsigned short srcy,
	unsigned short dstx, unsigned short dsty, unsigned short width, 
	unsigned short height);
BOOLEAN Gal_screen_to_screen_xblt(unsigned short srcx, unsigned short srcy,
                               unsigned short dstx, unsigned short dsty, 
                               unsigned short width, unsigned short height,
                               unsigned short color);
BOOLEAN Gal_bresenham_line(unsigned short x, unsigned short y, 
                        unsigned short length, unsigned short initerr, 
                        unsigned short axialerr, unsigned short diagerr, 
                        unsigned short flags);

BOOLEAN Gal_set_compression_state(BOOLEAN);
BOOLEAN Gal_set_compression_parameters(unsigned long flags, unsigned long offset,
                                       unsigned long pitch, unsigned long size);

BOOLEAN Gal_vga_mode_switch(int active);
BOOLEAN Gal_vga_clear_extended(void);
BOOLEAN Gal_vga_pitch(PGALAPP_VGAREGS pvregs, unsigned short pitch);
BOOLEAN Gal_vga_restore(PGALAPP_VGAREGS pvregs, int flags);
BOOLEAN Gal_vga_save(PGALAPP_VGAREGS pvregs, int flags);
BOOLEAN Gal_vga_mode(PGALAPP_VGAREGS pvregs, int xres, int yres, int bpp, int hz);
#endif
