#ifndef CONFIGWINDOW_H
#define CONFIGWINDOW_H

#include <QDialog>
#include <QtGui>
#include <QSettings>
#include <../powertable.h>

namespace Ui {
class ConfigWindow;
}

class ConfigWindow : public QDialog
{
    Q_OBJECT

public:
    explicit ConfigWindow(QString cfgFileName, QString powerFileName, QWidget *parent = 0);
    ~ConfigWindow();

private slots:
    void on_btnBkgr_clicked();

    void on_btnDraw_clicked();

    void on_btnHi_clicked();

    void on_btnLo_clicked();

    void on_btnNC_clicked();

    void on_twPower_cellDoubleClicked(int row, int column);

    void on_pin_changed(int row);

    void on_buttonBox_accepted();

    void on_sbSwitchesCount_valueChanged(int arg1);

    void on_btnDefaultPower_clicked();

private:
    Ui::ConfigWindow *ui;
    int PowerRoleToCode(QString role);
    QString PowerCodeToRole(int code);
    void repaintPower(PowerTable * pLUT);
    PowerTable * pLUT;
    QString cfgFileName;
};

#endif // CONFIGWINDOW_H
