#ifndef LOWLEVELTEST_H
#define LOWLEVELTEST_H

#include <QDialog>
#include "../devicedriver.h"
#include <QString>

namespace Ui {
class LowLevelTest;
}

class LowLevelTest : public QDialog
{
    Q_OBJECT

public:
    explicit LowLevelTest(QString port, int baudRate, QWidget *parent = 0);
    ~LowLevelTest();

private slots:
    void on_btnConnect_clicked();

    void on_cbPowerOn_clicked(bool checked);

    void on_btnAllOn_clicked();

    void on_btnAllOff_clicked();

    void on_pin_changed();

private:
    Ui::LowLevelTest *ui;
    QString currentSituation;
    void displaySituation();
    DeviceDriver * tester;
    QString port;
    int baud;
};

#endif // LOWLEVELTEST_H
