#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "icvisualizer.h"
#include "testlog.h"
#include <../powertable.h>
#include <../testsheet.h>
#include <../devicedriver.h>
#include <QColor>
#include <QString>
#include <QLabel>


namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private slots:
    void on_btnStart_clicked();

    void on_btnStop_clicked();


    void on_actionExit_triggered();

    void on_actionOpen_model_triggered();

    void on_actionShow_power_requirements_triggered();

    void on_actionCopy_log_to_clipboard_triggered();

    void on_actionDevice_reset_triggered();

    void on_actionConfiguration_triggered();

    void on_actionIdentify_device_triggered();

    void on_mru_used();
    void on_actionClear_history_triggered();

    void on_actionLow_level_interface_test_triggered();

    void on_actionEdit_current_test_sheet_triggered();

    void on_actionCreate_new_model_triggered();

    void on_actionAbout_triggered();

    void on_actionROM_dump_triggered();

private:
    void closeEvent(QCloseEvent *clsEv);
    Ui::MainWindow *ui;
    ICVisualizer * visualization;
    TestLog * testLog;
    QString pLUTPath;
    TestSheet * ICModel;
    QString commPort;
    int baudRate;
    int timeout;
    int stepDelay;
    QColor BkgColor;
    QColor HiColor;
    QColor LoColor;
    QColor NoColor;
    QColor DrwColor;
    QString settingsPath;
    void saveSettings();
    void loadSettings();
    void loadModel(QString fileName);
    void enableEverything();
    bool isRunning;
    QLabel * statusText;
    bool hardwareError(int code, int step, DeviceDriver *devToReset);
    QStringList MRU;
    void refreshMRU();

};

#endif // MAINWINDOW_H
