//Copyright 2014,2015 MCbx, All rights reserved.
//http://mcbx.netne.net/ictester
//This file is part of ICTester.
//ICTester is free software; you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation; either version 2 of the License, or
//(at your option) any later version.
//ICTester is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//You should have received a copy of the GNU General Public License
//along with ICTester; if not, write to the Free Software Foundation,
//Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef ROMDUMPER_H
#define ROMDUMPER_H

#include <QDialog>
#include <QProcess>

namespace Ui {
class ROMDumper;
}

class ROMDumper : public QDialog
{
    Q_OBJECT

public:
    explicit ROMDumper(QString port, QString pLUTPath, QWidget *parent = 0);
    ~ROMDumper();
    void repaintBuffer();
    QString port;
    QString pLUTPath;
    bool powerDisplayer();

public slots:
    void onFinished(int,QProcess::ExitStatus);

private slots:
    void on_cbType_currentIndexChanged(const QString &arg1);

    void on_btnLoad_clicked();

    void on_btnSave_clicked();

    void on_btnClear_clicked();

    void on_btnExit_clicked();

    void on_btnRead_clicked();

    void on_btnVerify_clicked();

private:
    Ui::ROMDumper *ui;
    QProcess *process;
    void controls(bool);

};

#endif // ROMDUMPER_H
