#include <iostream>
#include <string>
#include <sstream>
#include <iomanip>
#include "visualize.h"

std::string printHex(char* arr, unsigned int startLen, unsigned int offset,
              unsigned int totalLength, bool partComplete)
{
    std::stringstream ss;
    if (partComplete==1)
    {
        while (startLen%16!=0)
        {
            startLen--;
            offset++;
        }
        int rem = offset % 16;
        if (rem!=0) offset=offset+16-rem;
    }
    if (startLen>totalLength) return "";
    while (startLen+offset>totalLength)
    {
            offset--;   //cut to the end of file, usually not needed
    }

    char curChar;
    unsigned int i=0;
    unsigned int q=0;
    char TEMP_BUFFER[15];
    unsigned int counter = 0;
    ss<<std::setfill('0')<<std::setw(5);
    ss<<std::hex<<startLen<<": ";
    while (counter<offset+16)
    {
        curChar = arr[startLen+counter];

        if (i%16==0 && i!=0)    //every 16th byte
        {                       //throw ascii
            ss<<" | ";
            for (q=0;q<=15;q++)
            {
                if(TEMP_BUFFER[q] < 32 || TEMP_BUFFER[q] > 126)
                {
					ss<<".";
				}
				else
				{
					ss<<TEMP_BUFFER[q];
				}
            }
            ss<<"\n";
            if (counter<offset)
            {
                ss<<std::setfill('0')<<std::setw(5);
                ss<<startLen+counter<<": ";
            }
            q=0;
        }

        if(i % 8 == 0)  //separate bytes by additional space
        {
           ss<<" ";
        }

        if (counter>offset-1)
        {
            ss<<"   ";  //complete with spaces to end
            TEMP_BUFFER[q]=' '; //no more chars, fill with spaces
        }
        else
        {
            TEMP_BUFFER[q] = curChar;   //move current char to temp buf
        }
		if (counter<offset)
        {
		ss<<std::setfill('0')<<std::setw(2)<<std::uppercase<<std::hex;
		ss<<(int)((unsigned char)(curChar))<<std::nouppercase;
		ss<<" ";
        }
		i++;
		q++;

        counter++;
    }
    return ss.str();
}

