/*REXX
 * purpose: Submit a job using FTP client and commands in file.
 * systems: VM/CMS, MVS/TSO, MVS/USS, OS/2, AIX,
 *          Linux (on Intel x86 and on S/390), Windows
 */

PARSE ARG ftpIn ftpOut

PARSE UPPER SOURCE src
os1 = word(src, 1)
os2 = word(src, words(src))

say 'running on OS:'
say '  'os1 '[' os2 ']'
say 'plan is to:'
say '   fetch FTP cmds from local file :' ftpIn
say '   store FTP msgs in local file   :' ftpOut
say

SELECT
   WHEN ABBREV(os1, 'LIN') | os1 = 'AIX' THEN

      'ftp -n -v <' ftpIn '>' ftpOut

   WHEN os1 = 'TSO' & os2 = 'OPENMVS' THEN

      'ftp <' ftpIn '>' ftpOut

   WHEN os1 = 'TSO' THEN DO

      ADDRESS TSO
      'ALLOC DA('ftpIn')  DD(INPUT)  SHR REU'
      'ALLOC DA('ftpOut') DD(OUTPUT) SHR REU'
      'FTP'
      'FREE DD(INPUT)'
      'FREE DD(OUTPUT)'
      END

   WHEN os1 = 'CMS' THEN DO

      ADDRESS CMS
      'FILEDEF INPUT  DISK' ftpin  'DATA A'
      'FILEDEF OUTPUT DISK' ftpout 'DATA A'
      'FTP'
      'FILEDEF INPUT  CLEAR'
      'FILEDEF OUTPUT CLEAR'
      END

   WHEN ABBREV(os1, 'OS/2') THEN

      'FTP -n -v <' ftpIn '>' ftpOut

   WHEN ABBREV(os1, 'WIN') THEN

      'FTP -s:'ftpIn '>' ftpOut

   OTHERWISE
      say 'sorry, but your OS:' os1 'is not supported.'
END