/*********************************************************/
/*                                                       */
/* LIST2.CMD - IBM Object REXX Sample Program            */
/*                                                       */
/* ----------------------------------------------------- */
/* (C) Copyright IBM Corp. 1996 - All Rights Reserved.   */
/*                                                       */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]   */
/* code is sample code created by IBM Corporation. This  */
/* sample code is not part of any standard or IBM        */
/* product and is provided to you solely for the         */
/* purpose of assisting you in the development of your   */
/* applications.  The code is provided "AS IS", without  */
/* warranty of any kind.  IBM shall not be liable for    */
/* any damages arising out of your use of the sample     */
/* code,  even if they have been advised of the          */
/* possibility of such damages.                          */
/*                                                       */
/*********************************************************/

/* create a list object for strings */
myList = .List~New
myList~Insert("John")            /* add John to the list */

/* Add Bob and Anne to the end of the list. We will use  */
/* the ~~ operator (returning the object instead of a    */
/* result) for this purpose.                             */
myList~~Insert("Bob")~Insert("Anne")

/* show the number of elements in the list, should be 3  */
Say "The list now contains" myList~Items "items."

/* show the first item in the list, should be "John"     */
Index = myList~First       /* get index of first element */
Say "The first item in the list is" myList~At(Index)

/* insert Peter following the first item in the list     */
myList~Insert("Peter", Index)  /* add Peter after index  */

/* if an item should be inserted at the top of the list  */
/* you have to specify .nil as the index                 */
myList~Insert("David", .nil)

/* loop over all elements in the list and show them      */
Do ListItem Over myList
  Say ListItem~Reverse "is the reversed string of" ListItem
End
