/*****************************************************************************/
/* (C) Copyright IBM Corporation 1998.                                       */
/*                                                                           */
/* cgirxrmt.rex                      Web - CGI Rexx Interface - Client       */
/*                                                                           */
/* This code is sample code, provided "AS IS", without warranty of any kind  */
/*****************************************************************************/
Signal on any name error

envir = 'ENVIRONMENT'
script = value('SCRIPT_NAME',,envir)       /* Web server variables  */
who    = value('REMOTE_ADDR',,envir)
list   = value('QUERY_STRING',,envir)
parse var script '/cgi-bin/' type          /* extract request type  */
list=translate(list, ' ', '+'||'090a0d'x)  /* Whitespace, etc.      */

if left(type,7)='orxwww/' then do     
   cscr = script~substr(script~lastpos('/')+1)
   mutex = SysOpenMutexSem("ORXWWW")  /* Use semaphore for exclusive access */
   if mutex = 0 then do
       /* display error message and quit */
       say 'Content-Type: text/html'; say ''
       say '<p><b>Object REXX CGI Server has not been started!</b>'
       exit -1
   end
   if SysRequestMutexSem(mutex, 30000) \= 0 then call error
   else do
       oldq = rxqueue("SET","ORXWWW")
       queue "#S:"cscr "," type "," list "," who  /* send request to CGI server */
       data = ""
       call SysSleep 0 /* do a yield */
       call time "R"
       do while data \= "###FINISHED###"
           do while queued() = 0 & time("E") < 30; call SysSleep 0; end
           if queued() = 0 then leave
           do while queued() > 0    
               parse pull data
               if data~left(3)="#S:" then do /* Something that is for the CGI server */
                   push data            /* Push to the top of the queue again */
                   call SysSleep 0
               end  /* Error from CGI server, so display the error message */
               if data~left(11) = "###ERROR###" then do
                   parse var data ."("rc")"
                   signal error
               end    
               else do  /* HTML, so just display to send to internet server */
                   if data \= "###FINISHED###" then say data
                   call time "R"
               end    
           end
       end
       call rxqueue "SET", oldq
       call SysReleaseMutexSem mutex
   end
end 
else call error
call SysCloseMutexSem mutex
return

/*--------------- return the error in HTML format ---------------------*/
ERROR:
     say 'Content-Type: text/html'
     say ''
     say '<p><b>Invalid request of type:' type '<br>with parms:' list '</b>'
     say '<br>Who   :' who
     say '<br>Script:' script
     say '<br>Type  :' type
     say '<br>List  :' list
     say '<br>Error :' rc 
     say '<br>Line  :' sigl
     say '<br>Desc.1:' errortext(rc)
     say '<br>------------------ end of error msg -----------------<br>' 
     call SysReleaseMutexSem mutex
     call SysCloseMutexSem mutex
     return
