/*****************************************************************************/
/* (C) Copyright IBM Corporation 1998.                                       */
/*                                                                           */
/* cgirxsvr.rex                       Web - CGI Rexx Interface Server        */
/*                                                                           */
/* This code is sample code, provided "AS IS", without warranty of any kind  */
/*****************************************************************************/
mutex = SysCreateMutexSem("ORXWWW")  /* create semaphore for exclusive access */
if mutex = 0 then exit -1
if SysRequestMutexSem(mutex, 20) \= 0 then exit -2
nq = rxqueue("CREATE","ORXWWW") /* create external queue for inter-process communication */
if nq \= "ORXWWW" then call rxqueue "Delete", nq
oldq = rxqueue("SET","ORXWWW")

REQ:    
Signal on any name error  /* install signal handler for cleanup process (also called by Ctrl+C) */
do forever
    call SysReleaseMutexSem mutex
    say "Waiting for request... (press Ctrl+Break to stop server)"
    do while queued() = 0; call SysSleep 0; end  /* SysSleep to reduce CPU usage */
    parse pull request
    if request~left(3) \= "#S:" then do
        push request
        call SysSleep 0; iterate
    end    
    parse var request "#S:"cscr "," type "," list "," who
    cscr = cscr~strip
    say "Calling" cscr   
    call (cscr) type~strip, list~strip, who~strip, "ORXWWW"  /* call requested program */
    say "Requesting mutex..."
    if SysRequestMutexSem(mutex, 60000) \= 0 then do  /* timeout = 60 sec. */
        rc = "RC"; call error 
    end    
end 

ERROR:
queue "###ERROR###("rc")"
if condition("c") \= "HALT" then do
    if rc~DataType("N") = 1 then say "Error: " errortext(rc)
    say 'Description:' condition("o")~message
    if rc = 43 then do   /* is the error "Program not found?" */
       if SysRequestMutexSem(mutex, 60000) = 0 then signal REQ
    end
end    
call rxqueue "SET",oldq         /* Cleanup API manager */
call rxqueue "DELETE","ORXWWW"
call SysCloseMutexSem mutex     
