/*****************************************************************************/
/* (C) Copyright IBM Corporation 1998.                                       */
/*                                                                           */
/* cgirx_ih.rex                                     Web - CGI Rexx Interface */
/*                                                                           */
/* This code is sample code, provided "AS IS", without warranty of any kind  */
/*****************************************************************************/
Signal on any name error

parse upper source env . me
envir = 'ENVIRONMENT'
sourcedir = me~left(me~lastpos('\')-1)

script = value('SCRIPT_NAME',,envir)       /* Web server variables  */
who    = value('REMOTE_ADDR',,envir)
list   = value('QUERY_STRING',,envir)
parse var script '/cgi-bin/' type          /* extract request type  */
list=translate(list, ' ', '+'||'090a0d'x)  /* Whitespace, etc.      */

if left(type,7)='orxwww/' then do     
     x = directory(sourcedir)
     cscr = script~substr(script~lastpos('/')+1)
     call (cscr) type, list, who      /* call requested program */
end 
else call error
return

/*--------------- return the error in HTML format ---------------------*/
ERROR:
     say 'Content-Type: text/html'
     say ''
     say '<p><b>Invalid request of type:' type '<br>with parms:' list '</b>'
     say '<br>Who   :' who
     say '<br>Script:' script
     say '<br>Type  :' type
     say '<br>List  :' list
     say '<br>Dir   :' sourcedir
     say '<br>Error :' rc 
     say '<br>Line  :' sigl
     say '<br>Desc.1:' errortext(rc)
     say '<br>Desc.2:' condition("o")~message
     say '<br>------------------ end of error msg -----------------<br>' 
     return
