/*****************************************************************************/
/* (C) Copyright IBM Corporation 1998.                                       */
/*                                                                           */
/* This code is sample code, provided "AS IS", without warranty of any kind  */
/*****************************************************************************/
  parse arg type, list, who
  parse var list 'amount='amount'&interest='interest'&years='years'&fyear='fyear'&submit='submit

  NUMERIC DIGITS 14  /* determines the degree of accuracy */
  html = .HTML~new
  if arg(4,'o') = 0 then html~queue = arg(4) /* only needed for client-server CGI */
  html~title('Loan amortization calculated with Object REXX')
  html~h2('Loan amortization input')
  html~p('Please enter the following values and press "Calculate" to calculate the payment figures.')
  html~p
  if interest~DataType("N") = 0 then interest = 9
  if fyear~DataType("N") = 0 then fyear = date()~right(4)
  html~ilist("/cgi-bin/orxwww/www2_n")
  html~ili("Loan principal amount:", "Text","amount",amount,, "US$")
  html~ili("Annual interest rate:", "Text","interest",interest,,"%")
  html~ili("Loan period in years:", "Text","years",years)
  html~ili("Base year of loan:", "Text","fyear",fyear)
  html~ili(,"Submit", "submit", "Calculate")
  html~eilist
  if submit = 'Calculate' then do
      html~ingohome
      q = 1 + interest/100/12
      ann = amount*q**(years*12)*(q-1)/(q**(years*12)-1)
      tot_pay = ann*12*years
      
      html~h2('Payment overview')
      html~strong('The following figures are for monthly payment afterwards.')
      html~p

      keyf = .array~new(4,2)
      keyf[1,1] = "Annual loan payments:"
      keyf[1,2] = '$'Format(ann*12,,2)
      keyf[2,1] = "Monthly loan payments:"
      keyf[2,2] = '$'ann~format(,2)
      keyf[3,1] = "Interest over term of loan:   "
      keyf[3,2] = '$'Format(tot_pay-amount,,2)
      keyf[4,1] = "Sum of all payments:"
      keyf[4,2] = '$'tot_pay~format(,2)     /* no headers -> omit first argument */
      html~array2table(,keyf,.array~of("","align=right"),'border=5 cellpadding=5')
      
      html~h2('Amortization table')
      html~p
      bal = amount
      c_principal = 0
      c_int = 0
      amt = .array~new(years,8)
      do y = 1 to years
         amt[y,1] = fyear+y
         amt[y,2] = bal~format(,2)
         bal_e = bal*q**12 - ann*(q**12-1)/(q-1)
         a_int = ann*12-(bal-bal_e)
         amt[y,3] = Format(ann*12,,2)
         amt[y,4] = Format(bal-bal_e,,2)
         amt[y,5] = a_int~format(,2)
         c_principal = c_principal + bal-bal_e
         amt[y,6] = c_principal~format(,2)
         c_int = c_int + a_int
         amt[y,7] = c_int~format(,2)
         amt[y,8] = bal_e~format(,2)
         bal = bal_e
      end 
      html~array2table(.array~of('Year','Balance','Payments','Principal','Interest','Cum. Principal',
                       ,'Cum. Interest','Ending Balance'), amt, 'CURRENCY', 'border=1 cellpadding=4')

      html~pc; html~tt("This sample is based on a Lotus 123 example and was adapted by Ingo Holder.")
      html~pc; html~tt("All information is supplied without liability!")
  end    
  html~sign
  html~send   /* send the HTML to the internet server */
  return

::requires html.cls 
