/*****************************************************************************/
/* (C) Copyright IBM Corporation 1998.                                       */
/*                                                                           */
/* This code is sample code, provided "AS IS", without warranty of any kind  */
/*****************************************************************************/
  parse arg type, list, who 
  parse var list 'address='address '&' .
  parse upper source env . me
  sourcedir = me~left(me~lastpos('\')-1)

  html = .HTML~new
  if arg(4,'o') = 0 then html~queue = arg(4) /* only needed for client-server CGI */
  html~title('The Object REXX Address Book on the Web')

  /* check whether the address book has already been loaded */
  if .local~hasindex("My.Addressbook")=0 then do
      /* open address file and return error message if this fails */
      f = .stream~new(sourcedir"\address.dat")
      if f~open("READ") \= "READY:" then do
          html~strong("Couldn't open file Address.dat!")
          html~sign
          html~send
          return
      end
      /* create an array object and load all addresses of the file into the array.
         Every single address is a directory */
      addr = .array~new(100)
      i = 1
      do s over f
          parse var s nr "," name "," street "," city "," country "," phone
          d = .directory~new   /* create a directory object and assign address */
          d['NR'] = nr
          d['NA'] = name
          d['ST'] = street
          d['CI'] = city
          d['CO'] = country
          d['PH'] = phone
          addr[i] = d
          i = i +1
      end
      .local["My.Addressbook"]=addr  /* store array in local environment */
  end
  else do
      addr = .local["My.Addressbook"] /* just get the previously loaded array */
      call beep 550, 500
  end    
        
  if address~DataType("N") = 0 then address = ""  /* also true for "List all addresses" */
  if address = "" then do    /* if we want to list all addresses */
      html~h2('All addresses...')
      html~p
      html~table('border=2 cellpadding=2')
      html~tr
      html~~th('Number')~~th('Name')~~th('City')
      do ad over addr  /* list all addresses in a table */
         html~tr
         html~td('','align=left')
         /* The number field is also a reference to this script
            with address=[the selected number] */
         html~href('www3?address='ad['NR'],ad['NR'])
         html~etd
         html~td(ad['NA'])
         html~td(ad['CI'])
      end 
      html~etable
  end    
  else do  /* we have a particular address */
      html~h2('Address of 'addr[address]['NA'])
      html~p
      /* List all information of the selected address in a table */
      html~table('border=3 cellpadding=2')
      html~tr; html~td("Number")
      html~td(addr[address]['NR'])
      html~tr; html~td("Name")
      html~td(addr[address]['NA'])
      html~tr; html~td("Street")
      html~td(addr[address]['ST'])
      html~tr; html~td("City")
      html~td(addr[address]['CI'])
      html~tr; html~td("Country  ")
      html~td(addr[address]['CO'])
      html~tr; html~td("Phone")
      html~td(addr[address]['PH'])
      html~etable
      /* add the "List all addresses" button */
      html~form("/cgi-bin/orxwww/www3")  
      html~p; html~input("Submit", "address", "List all addresses")
      html~eform
  end
  html~sign
  html~send  /* send the HTML to the internet server */
  return

::requires html.cls
