/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  NetCentric Computing with Object Rexx                                   */
/*  Programming Example                                                     */
/*                                                                          */
/*    Kurt Maerker       Kurt_Maerker@vnet.ibm.com                          */
/*                                                              03/03/97    */
/*  Basic_c.cmd  -  Simple Client using TCP/IP Sockets                      */
/*                                                                          */
/*    Client program for the server. Ask the user for a string,             */ 
/*    send the string to the server and print the received string.          */
/*                                                                          */
/*    Parameters:                                                           */
/*      Port:   server port number                                          */
/*      Server: alias name of server                                        */
/*                                                                          */
/*--------------------------------------------------------------------------*/

Parse Arg Port Server 
if Port = '' then Port = 1920          /* Default is Bounce sever           */

client = .tcpClient~new(Server, Port)  /* create client for server via port */

if client~connected then do              
                                       /* get user input and send to server */
  rc = client~promptInput("Please enter a string to be sent to the server")
  if rc < 0 then leave                 /* worked ok?                        */

  Say "The string '" || client~input || "' was sent to the server."

  rc = client~receive                  /* receive the returned string       */
  if rc < 0 then leave                 /* worked ok?                        */

  Say "The string '" || client~output || "' was received from the server."
end 

client~shutdown
return

::REQUIRES "clients.frm"               /* Use the clients framework         */   

