/*--------------------------------------------------------------------------*/
/* Agent PUT for remote processing with implicit communications             */
/*--------------------------------------------------------------------------*/

parse arg file option
fname = filespec('name', file)         /* does file already exist on server?*/
fullname = .stream~new(fname)~query('EXISTS')

select 
  when option = '' then do
    if fullname \= '' then do          /* file already exists               */ 
      say 'File' fname 'already exists'
      return 1
    end
  end
                                       /* for replace do it anyway          */
  when 'REPLACE'~abbrev(option~translate, 3) then nop
  otherwise
    say "Specified option unknown:" Option
    return 1
end 

say '#>>Put file='file option'<<#'       /* initiate the put transmission     */
return 0   

