/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  NetCentric Computing with Object Rexx                                   */
/*  Programming Example                                                     */
/*                                                                          */
/*    IBM Corporation 1998                                                  */
/*                                                                          */
/*  wClient.cmd  -  A simple WWW Client using TCP/IP Sockets                */
/*                                                                          */
/*    Client program that connects to a remote server supporting HTTP/1.0   */ 
/*    protocol. The designated document header of body is retrieved and     */
/*    displayed on the client.                                              */
/*                                                                          */
/*    Parameters:                                                           */
/*      Port:     HTTP server port number (optional)                        */
/*                                                                          */
/*--------------------------------------------------------------------------*/

Parse Arg Port
if Port = '' then Port = 80            /* Default port of HTTP server       */
                                       /* register utility function         */ 
rc = RxFuncAdd("sysTempFileName", "rexxutil", "SysTempFileName")     
                                       /* get a temporary filename          */
tempfile = sysTempFileName('HTTP???.TMP')
                                       /* define set of valid commands      */ 
commands = .set~of('FILE', 'GET', 'HEAD', 'POST', 'QUIT', '?')
say "Please enter a command" 
say                                     
client = .tcpClient~new()              /* Create an unconnected client      */
system = client~sysinfo                /* Determine client system platform  */  

do while client~getInput() = 0         /* Run session until entering 'quit' */
               
  command = client~Input~word(1)~translate 
  parm = client~input~subword(2)       /* get parameters from input         */
  cmd = commands[command] 
              
  select                               /* Handle client commands...         */
    when cmd = '?' then                /* handle ? (brief help) command     */
      say 'Valid commands are ?, FILE, HEAD, GET, POST, and QUIT'

    when cmd = 'QUIT' then leave       /* QUIT client session               */                             

    when cmd = 'FILE' then do          /* FILE the data received last       */ 
      select
        when system = 'OS/2' | system = 'Windows95' | system = 'WindowsNT' then
          'move' tempfile parm
        when system = 'LINUX' | system = 'AIX' then
          'mv' tempfile parm
        otherwise
          say 'Unsupported system:' system 
      end 
    end

    when .nil \= cmd then do           /* handle HTTP/1.0 commands          */
      Parse Var parm "http://" Server "/" Document
      Document = "/" || Document
                                       /* HTTP/1.0 command w/o parameters   */
      command = Command Document "HTTP/1.0" || "0D0A0D0A"x
                                       /* connect tcpClient sending command */
      client~init(Server, Port, '!', command)
      if client~connected then do      /* Is client connected to server?    */
        say '--- Begin of transmission ---'
                                       /* now receive the requested info    */
        if client~receiveFile(tempfile, 'NOHEADER') > 0 then do
          file = .stream~new(tempfile)
          do line over file            /* display the information           */ 
            say line
          end
          file~close
        end 
        else 
          say 'Problems receiving document'
    
        say '--- End of transmission ---'
      end      
      client~shutdown                  /* client connection is shutdown now */
    end 

    otherwise                          /* handle unrecognized commands      */
      say 'Invalid command:' command'; valid commands are FILE, HEAD, GET, POST, QUIT'
  end  
end 
rc = sysFileDelete(tempfile)           /* delete the temporary file         */
say 'Session terminated'

exit   

/****************************************************************************/

::REQUIRES "clients.frm"               /* Use the clients framework         */   

