/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  NetCentric Computing with Object Rexx                                   */
/*  Programming Example                                                     */
/*                                                                          */
/*    IBM Corporation 1998                                                  */
/*                                                                          */
/*  Yodel_c.cmd  -  Session Client using TCP/IP Sockets                     */
/*                                                                          */
/*    Client program for the server. Ask the user for a string,             */ 
/*    send the string to the server and display the result string.          */
/*                                                                          */
/*    Parameters:                                                           */
/*      Server: alias name of the server                                    */
/*      alias:  alias name of the client                                    */
/*      Port:   server port number (optional)                               */
/*                                                                          */
/*--------------------------------------------------------------------------*/

Parse Arg Server clientName Port                 
if Port = '' then Port = 1923          /* Default is yodel server           */
                                       /* create client for server via port */
client = .yodelClient~new(Server, Port, clientName)
if client~connected then do            /* Is client connected to server?    */
  client~listen                        /* listen to answer and display it   */ 
  client~raiseVoice                    /* process session until 'quit'      */ 
end
return

/****************************************************************************/

::REQUIRES "clients.frm"               /* Use the clients framework         */   

/*--------------------------------------------------------------------------*/
/* yodelClient Class definition                                             */
/*--------------------------------------------------------------------------*/
::CLASS yodelClient SUBCLASS tcpClient

/*--------------------------------------------------------------------------*/
::METHOD raiseVoice 
  say "Please enter your words to be yodeled"
  say ""
                                       /* Take user input until 'quit'      */
  do until self~Input~word(1)~translate = 'QUIT' 
    if self~promptInput() < 0 then     /* get input from user               */
      self~sendInput('QUIT')           /* in case of problems 'quit'        */
  end 

/*--------------------------------------------------------------------------*/
::METHOD listen UNGUARDED
  reply                                /* Frees up other concurrent work    */ 
                                              
  do forever                           /* Listen to returned words          */
    if self~receive < 0 then leave     /* if error terminate receive loop   */
    RetString = self~Output            /* get the output received           */
    if RetString = "#>>End_of_session<<#" then leave 
    Say "*" RetString                  /* show the result                   */
  end

  self~shutdown                        /* shutdown client                   */
