/******************************************************************************/
/*  ccreply                  Object REXX Samples                              */
/*                                                                            */
/*  A concurrent programming example.                                         */
/*                                                                            */
/*                                                                            */
/*  Licensed Materials - Property of IBM                                      */
/*  IBM Object REXX for AIX                                                   */
/*  (C) Copyright IBM Corp. 1998,  2004                                       */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]                        */
/* code is sample code created by IBM Corporation. This                       */
/* sample code is not part of any standard or IBM                             */
/* product and is provided to you solely for the                              */
/* purpose of assisting you in the development of your                        */
/* applications.  The code is provided "AS IS", without                       */
/* warranty of any kind.  IBM shall not be liable for                         */
/* any damages arising out of your use of the sample                          */
/* code,  even if they have been advised of the                               */
/* possibility of such damages.                                               */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/*  Description:                                                              */
/*  This program demonstrates how to use reply to run two methods at the same */
/*  time.                                                                     */
/******************************************************************************/
object1 = .example~new                      /* Create two new instances of    */
object2 = .example~new                      /* the example class.             */

say object1~repeat(10, 'Object 1 running')  /* Start first object running     */
say object2~repeat(10, 'Object 2 running')  /* Start second object running    */
say 'Main ended.'
exit                                        /* Exit and watch our kids run    */


::class example                             /* Define the example class       */
::method repeat                             /* Define the repeat method       */
  use arg reps,msg
  reply 'Repeating "'msg'",' reps 'times.'  /* Reply so others can run        */
  do reps
    say msg                                 /* Show that we're working        */
  end
