/***************************************************************************/
/*                                                                         */
/*  rexxasp1.c               Object REXX samples                           */
/*                                                                         */
/*  Licensed Materials - Property of IBM                                   */
/*  IBM Object REXX for AIX                                                */
/*  (C) Copyright IBM Corp. 1998,  2004                                    */
/*                                                                         */
/* ----------------------------------------------------------------------- */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]                     */
/* code is sample code created by IBM Corporation. This                    */
/* sample code is not part of any standard or IBM                          */
/* product and is provided to you solely for the                           */
/* purpose of assisting you in the development of your                     */
/* applications.  The code is provided "AS IS", without                    */
/* warranty of any kind.  IBM shall not be liable for                      */
/* any damages arising out of your use of the sample                       */
/* code,  even if they have been advised of the                            */
/* possibility of such damages.                                            */
/* ----------------------------------------------------------------------- */
/*                                                                         */
/*  Description:       functions used by Object REXX script                */
/*                                                                         */
/***************************************************************************/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#define  INCL_REXXSAA
#define  INCL_DOSMEMMGR
#include <rexx.h>

/*********************************************************************/
/* Numeric Return calls                                              */
/*********************************************************************/

#define  INVALID_ROUTINE 10            /* Raise Rexx error           */
#define  VALID_ROUTINE    0            /* Successful completion      */

#ifdef __cplusplus
extern "C" {
#endif

/*********************************************************************/
/* AspiFncTable                                                      */
/*   Array of names of the REXXASP1 functions.                       */
/*   This list is used for registration and deregistration.          */
/*********************************************************************/
static PSZ  AspiFncTable[] =
   {
      "Aspi_Output_From_C",
      "Aspi_Output_From_REXX",
      "Aspi_Exchange_Data",
      "AspiDeregFunc"
   };


/*************************************************************************
* Function:  AspiLoadFuncs                                               *
*                                                                        *
* Syntax:    call AspiLoadFuncs                                          *
*                                                                        *
* Params:    none                                                        *
*                                                                        *
* Return:    null string                                                 *
*************************************************************************/

LONG APIENTRY AspiLoadFuncs(
  PSZ       name,                      /* Function name              */
  LONG      numargs,                   /* Number of arguments        */
  RXSTRING  args[],                    /* Argument array             */
  PSZ       queuename,                 /* Current queue              */
  PRXSTRING retstr )                   /* Return RXSTRING            */
{
  INT    entries;                      /* Num of entries             */
  INT    j;                            /* Counter                    */


  entries = sizeof(AspiFncTable)/sizeof(PSZ);

  for (j = 0; j < entries; j++)
  {
    RexxRegisterFunctionDll(AspiFncTable[j],
          "rexxasp1", AspiFncTable[j]);
  }
  return VALID_ROUTINE;
}



/*************************************************************************
* Function:  AspiDeregFunc                                               *
*                                                                        *
* Syntax:    call AspiDeregFuncs                                         *
*                                                                        *
* Params:    none                                                        *
*                                                                        *
* Return:    null string                                                 *
*************************************************************************/

LONG APIENTRY AspiDeregFunc(
  PSZ       name,                      /* Function name              */
  LONG      numargs,                   /* Number of arguments        */
  RXSTRING  args[],                    /* Argument array             */
  PSZ       queuename,                 /* Current queue              */
  PRXSTRING retstr )                   /* Return RXSTRING            */
{
  INT    entries;                      /* Num of entries             */
  INT    j;                            /* Counter                    */

  retstr->strlength = 0;               /* set return value           */

  if (numargs > 0)
    return INVALID_ROUTINE;


  entries = sizeof(AspiFncTable)/sizeof(PSZ);

  for (j = 0; j < entries; j++)
  {
    RexxDeregisterFunction(AspiFncTable[j]);
  }
  return VALID_ROUTINE;
}



/*************************************************************************
* Function:  Aspi_Output_From_C                                          *
*                                                                        *
* Syntax:    call Aspi_Output_From_C                                     *
*                                                                        *
* Params:    none                                                        *
*                                                                        *
* Return:    Version of this ASPI support DLL                            *
*************************************************************************/

LONG APIENTRY Aspi_Output_From_C(
  PSZ       name,                      /* Function name              */
  LONG      numargs,                   /* Number of arguments        */
  RXSTRING  args[],                    /* Argument array             */
  PSZ       queuename,                 /* Current queue              */
  PRXSTRING retstr )                   /* Return RXSTRING            */
{

  if (numargs > 0)
  {
    strcpy(retstr->strptr, "Aspi_OutPut_From_C does not support any Arguments");
    retstr->strlength = strlen(retstr->strptr);
    return VALID_ROUTINE;
  }

  printf("This Output is generated and displayed by the C-function Aspi_Output_From_C\n");
  fflush(NULL);
  return VALID_ROUTINE;
}


/*************************************************************************
* Function:  Aspi_Output_From_REXX                                       *
*                                                                        *
* Syntax:    call Aspi_Output_From_C                                     *
*                                                                        *
* Params:    none                                                        *
*                                                                        *
* Return:    Version of this ASPI support DLL                            *
*************************************************************************/

LONG APIENTRY Aspi_Output_From_REXX(
  PSZ       name,                      /* Function name              */
  LONG      numargs,                   /* Number of arguments        */
  RXSTRING  args[],                    /* Argument array             */
  PSZ       queuename,                 /* Current queue              */
  PRXSTRING retstr )                   /* Return RXSTRING            */
{
  if (numargs > 0)
  {
    strcpy(retstr->strptr, "Aspi_OutPut_From_REXX does not support any Arguments");
    retstr->strlength = strlen(retstr->strptr);
    return VALID_ROUTINE;
  }
  strcpy(retstr->strptr, "This Output is generated by the C-function Aspi_Output_From_REXX and displayed by REXX");
  retstr->strlength = strlen(retstr->strptr);
  return VALID_ROUTINE;
}
/*************************************************************************
* Function:  Aspi_Exchange_Data                                          *
*                                                                        *
* Syntax:    call Aspi_Exchange_Data startsect, numsects, outbuf         *
*                                                                        *
* Params:    parm1 - numeric value given by REXX                         *
*            parm2 - numeric value given by REXX                         *
*            outbuf - variable given by REXX                             *
*                                                                        *
* Return:    0 - success, 1 - failure                                    *
*************************************************************************/

LONG APIENTRY Aspi_Exchange_Data(
  PSZ       name,                      /* Function name              */
  LONG      numargs,                   /* Number of arguments        */
  RXSTRING  args[],                    /* Argument array             */
  PSZ       queuename,                 /* Current queue              */
  PRXSTRING retstr )                   /* Return RXSTRING            */
{
  int    parm1 = 0;
  int    parm2 = 0;
  char   outbuf[255];
  char   *ptr;
  int    i;
  SHVBLOCK shvb;

  /* we expect 3 arguments */

  if (numargs != 3 )
  {
    strcpy(retstr->strptr, "Aspi_Exchange_Data function expects 3 arguments");
    retstr->strlength = strlen(retstr->strptr);
    return VALID_ROUTINE;
  }

  strcpy(retstr->strptr, "\0");
  retstr->strlength = strlen(retstr->strptr);

  /* read the values from the parameters */

  parm1 = atoi(args[0].strptr);
  parm2 = atoi(args[1].strptr);
  strcpy(outbuf, args[2].strptr);

  printf("Aspi_Exchange_Data function has received following arguments:\nArgument 1: %d\nArgument 2: %d\nArgument 3: %s\n",
         parm1, parm2, outbuf);
  fflush(NULL);

  return VALID_ROUTINE;

}

#ifdef __cplusplus
}
#endif
