/******************************************************************************/
/*  stack                    Object REXX Samples                              */
/*                                                                            */
/*  A stack class                                                             */
/*                                                                            */
/*                                                                            */
/*  Licensed Materials - Property of IBM                                      */
/*  IBM Object REXX for AIX                                                   */
/*  (C) Copyright IBM Corp. 1998,  2004                                       */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]                        */
/* code is sample code created by IBM Corporation. This                       */
/* sample code is not part of any standard or IBM                             */
/* product and is provided to you solely for the                              */
/* purpose of assisting you in the development of your                        */
/* applications.  The code is provided "AS IS", without                       */
/* warranty of any kind.  IBM shall not be liable for                         */
/* any damages arising out of your use of the sample                          */
/* code,  even if they have been advised of the                               */
/* possibility of such damages.                                               */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/*  Description:                                                              */
/*  This program demonstrates how to implement a stack class using ::class    */
/*  and ::method directives.  Also included is a short example of the use of  */
/*  a stack.                                                                  */
/******************************************************************************/

mystack = .stack~new                        /* Create a new instance of stack */
mystack~push('John Smith')
mystack~push('Bill Brown')
say 'Size of stack:' mystack~items          /* Displays size of stack         */
say 'Pop stack:    ' mystack~pop            /* Displays item popped off stack */
say 'Pop stack:    ' mystack~pop            /* Displays next item popped off  */
say 'Pop stack:    ' mystack~pop            /* Stack now empty - displays     */
                                            /*   "The NIL Object"             */

/* Define the stack class (a subclass of Object Class) */
::class stack

/* Define the init method on the stack class */
::method init
expose contents                             /* Object var with stack contents */
self~init:super                             /* Run init method of superclass  */
contents = .list~new                        /* Use a list to keep stack items */

/* Define the push method on the stack class */
::method push
expose contents
use arg item
contents~insert(item, .nil)

/* Define the pop method on the stack class */
::method pop
expose contents
if contents~items > 0 then
  return contents~remove(contents~first)
else
  return .nil

/* Define the items method on the stack class to return number of items */
::method items
expose contents
return contents~items
