/******************************************************************************/
/*  usecomp                  Object REXX Samples                              */
/*                                                                            */
/*  A simple demonstration of the complex number class                        */
/*                                                                            */
/*                                                                            */
/*  Licensed Materials - Property of IBM                                      */
/*  IBM Object REXX for AIX                                                   */
/*  (C) Copyright IBM Corp. 1998,  2004                                       */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]                        */
/* code is sample code created by IBM Corporation. This                       */
/* sample code is not part of any standard or IBM                             */
/* product and is provided to you solely for the                              */
/* purpose of assisting you in the development of your                        */
/* applications.  The code is provided "AS IS", without                       */
/* warranty of any kind.  IBM shall not be liable for                         */
/* any damages arising out of your use of the sample                          */
/* code,  even if they have been advised of the                               */
/* possibility of such damages.                                               */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/*  Description:                                                              */
/*  This program demonstrates use of the ::requires directive using the       */
/*  complex number class included in the samples.                             */
/******************************************************************************/

Say 'A simple example of complex number arithmetic:'
comp1 = .complex[8,4]                       /* create two complex numbers     */
comp2 = .complex[4,1]

/* Note that SAY uses the STRING method of the COMPLEX class for display      */
say '('comp1') + ('comp2') is' comp1+comp2
say '('comp1') - ('comp2') is' comp1-comp2
say '('comp1') * ('comp2') is' comp1*comp2
say '('comp1') / ('comp2') is' comp1/comp2
say '('comp1') % ('comp2') is' comp1%comp2
say '('comp1') // ('comp2') is' comp1//comp2

::REQUIRES 'complex'
