/**********************************************************************/
/*                                                                    */
/* SAMP02.REX: OLE Automation with Object REXX - Sample 2             */
/*                                                                    */
/* Show some features of the Windows Scripting Host Shell Object:     */
/*  - Query environment strings (only for Windows NT)                 */
/*  - List special folders                                            */
/*  - Create a shortcut on the desktop                                */
/*                                                                    */
/* This sample requires the Windows Scripting Host to be installed on */
/* the system. See http://msdn.microsoft.com/scripting/ for details.  */
/*                                                                    */
/* ------------------------------------------------------------------ */
/* (C) Copyright IBM Corp. 1998 - All Rights Reserved.                */
/*                                                                    */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is sample */
/* code created by IBM Corporation. This sample code is not part of   */
/* any standard or IBM product and is provided to you solely for the  */
/* purpose of assisting you in the development of your applications.  */
/* The code is provided "AS IS", without warranty of any kind.  IBM   */
/* shall not be liable for any damages arising out of your use of the */
/* sample code,  even if they have been advised of the possibility of */
/* such damages.                                                      */
/*                                                                    */
/**********************************************************************/

WshShellObj = .OLEObject~New("WScript.Shell")

Parse Source OpSys . .
If OpSys = "WindowsNT" Then Do
  WshEnv = WshShellObj~Environment
  Say "Operating system:" WshEnv["OS"]
  Say "You have" WshEnv["NUMBER_OF_PROCESSORS"] "processor(s) of",
      WshEnv["PROCESSOR_ARCHITECTURE"] "architecture in your system."
End

Say "The following directories represent special folders on your system:"
Do Folder Over WshShellObj~SpecialFolders
  Say "   " Folder
End

Say "Creating a shortcut for NOTEPAD.EXE on your Desktop..."
Desktop = WshShellObj~SpecialFolders("Desktop")
ShortCut = WshShellObj~CreateShortcut(Desktop || "\Shortcut to Notepad.lnk")
ShortCut~TargetPath = "%WINDIR%\notepad.exe"
ShortCut~Save

WshShellObj~Popup("Processing of REXX script has finished!")

::REQUIRES OREXXOLE.CLS
