/**********************************************************************/
/*                                                                    */
/* SAMP04.REX: OLE Automation with Object REXX - Sample 4             */
/*                                                                    */
/* Create a mail message in Lotus Notes and send it to a number of    */
/* recipients automatically.                                          */
/*                                                                    */
/* ------------------------------------------------------------------ */
/* (C) Copyright IBM Corp. 1998 - All Rights Reserved.                */
/*                                                                    */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is sample */
/* code created by IBM Corporation. This sample code is not part of   */
/* any standard or IBM product and is provided to you solely for the  */
/* purpose of assisting you in the development of your applications.  */
/* The code is provided "AS IS", without warranty of any kind.  IBM   */
/* shall not be liable for any damages arising out of your use of the */
/* sample code,  even if they have been advised of the possibility of */
/* such damages.                                                      */
/*                                                                    */
/**********************************************************************/

Session = .OLEObject~New("Notes.NotesSession")
MailServer = Session~GetEnvironmentString("MailServer", .True)
MailFile = Session~GetEnvironmentString("MailFile", .True)
MailDb = Session~GetDatabase(MailServer, MailFile)

Say "Creating mail to be sent to two recipients..."
MailDoc = MailDb~CreateDocument
MailDoc~Form = "Memo"
MailDoc~Logo = "StdNotesLtr9"
MailDoc~From = "Christian Michel"
MailDoc~Subject = "REXX OLE automation test mail"

/* create a new body text with multiple lines */
NewBody = MailDoc~CreateRichTextItem("Body")
NewBody~AppendText("To the readers of this mail message:")
NewBody~AddNewLine(2)
NewBody~AppendText("This mail has been sent with Object REXX for Windows.")
NewBody~AddNewLine(1)
NewBody~AppendText("It was created automatically at" Time("N") "on" Date("N"))
NewBody~AppendText(" and then sent without any user interacting with the program.")

/* create an array of the recipients */
Recipients = .Array~Of("Recipient 1", "Recipient 2")
MailDoc~SendTo = Recipients
MailDoc~Save(.False, .False)
MailDoc~Send(.False, Recipients)
Say "Mail has been sent"

::REQUIRES OREXXOLE.CLS
