/*****************************************************************************/
/* Another Form with Select List                                   form3.cmd */ 
/*                                                                           */
/* (C) Copyright IBM Corporation 1999.                                       */
/*                                                                           */
/* This code is sample code, provided "AS IS", without warranty of any kind  */
/*****************************************************************************/

use arg type, list, address            /* get the arguments                  */

parm = .parmdir~new(list)              /* create parameter directory         */

html = .myHtml~new                     /* create an html object              */          
html~title('Yet Another Form with Object REXX')
html~h1('Another' big(yellow('Form')) 'with more Input')

if 'Process' = parm['submit'] then do   
  html~p("You entered:")
  html~p("name = "green(parm['name']))
  html~p("dept = "green(parm['dept']))
  html~br("check1 = "green(parm['check1']))
  html~br("check2 = "green(parm['check2']))
  html~br("check3 = "green(parm['check3']))
  html~br("check4 = "green(parm['check4']))
  html~br("check5 = "green(parm['check5']))
  html~p("text:")
  html~br(green(breaks(parm['text'])))

  html~form("/cgi-bin/orxwww/form3")   /* cgi-form with 'Again' button       */ 
  html~submit("submit", "Again")
  html~eform
end
else do
  html~p('Enter your selections and entries and press "Process" to continue.')
  html~form("/cgi-bin/orxwww/form3")
  html~br
  html~table('with=100% border=0 cellpadding=10')
  html~tr
  html~td(, 'valign=top')~b('Name:')
  html~itext('name', '')~etd 
  html~td(, 'valign=top')~b('Department:')
  html~radio('dept', 'PROD', 'unchecked', 'PROD')
  html~radio('dept', 'R&D', 'checked', 'R&D')
  html~radio('dept', 'PROG', 'uncchecked', 'PROG')~etd
  html~tr
  html~td(, 'valign=top')
  html~b('Select any of these:')
  html~br~check('check1', 'one', 'unchecked', 'Office')
  html~br~check('check2', 'two', 'checked', 'Public transport')
  html~br~check('check3', 'three', 'unchecked', 'Home')
  html~br~check('check4', 'four', 'unchecked', 'Aeroplane')
  html~br~check('check5', 'five', 'unchecked', 'Private car')~etd
  html~td(, 'valign=top')
  html~b('Enter your comments here:')   
  html~br~textarea('text', 4 35, ,' ')~etd 
  html~etable
  html~P~submit("submit", "Process")
  html~eform 
end   

html~footing("/orxwww/form3.cmd")      /* footing with code reference        */
return html~end                        /* end HTML document and return it    */

::requires "myhtml.cls"                /* load myHtml class                  */
