#! /usr/local/orexx/bin/rexx
/****************************************************************************/
/* Name:        genLTree.cmd                                                */
/* Function:    Generate a local directory tree                             */
/* Type:        Object REXX Script                                          */     
/*                                                                          */     
/* Requirement: xFtp.cls and ftp framework ftp.frm                          */
/****************************************************************************/

ftp = .xFtp~new                         -- create xftp object
say 'local slash' ftp~lslash            -- local slash 
say 'local dir:' directory('deldir')    -- change to and display local dir
ftp~showLDir(, 'd')                     -- show its directories before
say 
say '-----genLDirTree ------'           -- define the array of paths
paths = .array~of('aaa/uuu/xxx/', 'aaa/uuu/yyy/', 'aaa/bbb/', -
                  'aaa/bbb/vvv/', 'aaa/ccc/')
rc = ftp~genLDirTree(paths)             -- generate local directory tree
say 'local directory tree "aaa" generated with rc:' rc 
ftp~showLDir(, 'd')                     -- show its directories after

::REQUIRES "xftp.cls" 