#! /usr/local/orexx/bin/rexx
/****************************************************************************/
/* Name:        getLlist.cmd                                                */
/* Function:    Get a directory list of local directory                     */
/* Type:        Object REXX Script                                          */     
/*                                                                          */     
/* Requirement: xFtp.cls and ftp framework ftp.frm                          */
/****************************************************************************/      

ftp = .xFtp~new                         -- create ftp object
say 'Local system type:' ftp~lSysType 
say 'with slash' ftp~lslash             -- local slash    
say 'local dir:' directory()
say
say say '-----getLDirList()--------'
say 'gets a list of <t name> entries (with t: 0 - file, 1 - dir)'      
say '---- begin of list -----------'
list = ftp~getLDirList()                -- use xftp method on current dir
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----getLDirList(*e*)---------'
say 'gets a list of <t name> entries (with t: 0 - file, 1 - dir) matching pattern'      
say '---- begin of list -----------'
list = ftp~getLDirList('*e*')            -- use xftp method with pattern
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----getLDirList(,F)----------'
say 'gets a list of <name> entries with file names'      
say '---- begin of list -----------'
list = ftp~getLDirList(,'F')             -- use xftp method on files only 
if list \= -1 & list \= 0 then
do p over list; say p; end 
say
say '-----getLDirList(m*,F)--------'
say 'gets a list of <name> entries with file names matching pattern'      
say '---- begin of list -----------'
list = ftp~getLDirList('m*','F')         -- use xftp method with pattern on files only
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----getRDirList(,D)----------'
say 'gets a list of <name> entries with directory names'      
say '---- begin of list -----------'
list = ftp~getLDirList(,'D')             -- use xftp method on directories only
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----getLDirList(T*,D)--------'
say 'gets a list of <name> entries with directory names matching pattern'      
say '---- begin of list -----------'
list = ftp~getLDirList('T*','D')         -- use xftp method with pattern on dirs only
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----getLDirList(target,usr)--'
say 'gets a list of <t name> entries (with t: 0 - file, 1 - dir)'      
say '---- begin of list -----------'
list = ftp~getLDirList('target')            -- use xftp method in dir 'usr'
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----getLDirList(target,F)----'
say 'gets a list of <name> entries with file names in directory "target"'      
say '---- begin of list -----------'
list = ftp~getLDirList('target','F')        -- use xftp method on files only in dir 'usr'
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----getLDirList(target,D)----'
say 'gets a list of <name> entries with directory names in directory "target"'      
say '---- begin of list -----------'
list = ftp~getLDirList('target','D')        -- use xftp method on directories only
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
exit 0 

::REQUIRES "xftp.cls"
 