#! /usr/local/orexx/bin/rexx
/****************************************************************************/
/* Name:        mdel.cmd                                                    */
/* Function:    Delete multiple entries in remote directory                 */
/* Type:        Object REXX Script                                          */     
/*                                                                          */     
/* Requirement: xFtp.cls and ftp framework ftp.frm                          */
/****************************************************************************/      

ftp = .xFtp~new                         -- create ftp object
ftp~debug = .true                       -- request debug messages 
                                        -- connect to server 
if ftp~connect('host', 'userid', 'password') \= 0 then exit 
say ftp~sys(sys)                        -- determine ftp-server type
say 'with slash' ftp~rslash             -- remote slash   
say 'remote dir:' ftp~pwd

ftp~cd('deldir')                        -- change to directory
say 'remote dir:' ftp~pwd
say
rc = ftp~getRDirList()                  -- show what's in there
if rc \= -1 & rc \= 0 then do
  say 'files/directories found in "deldir":'
  do dir over rc; say dir; end
end 
say '-----delete(fname)---------'
say 'deletes a file from the current remote directory'      
rc = ftp~delete('myfile.txt')           -- use base ftp method
say 'remote file deleted with rc =' rc 
say
say '-----mdel()----------------'
say 'delete all files from the current remote directory'      
rc = ftp~mdel()                         -- use xftp method
say 'all files deleted from remote directory "deldir" with rc =' rc 
say
say '-----mdel(,dir)------------'
say 'delete all files from remote directory "targetx"'      
rc = ftp~mdel(, 'targetx')              -- use xftp method
say 'all files deleted from remote directory "targetx" with rc =' rc 
say  
say '-----mget(pattern,dir)-----'
say 'delete all files from remote directory "targety" matching pattern "*.txt"'      
rc = ftp~mdel('*.txt', 'targety')       -- use xftp method
say 'remote matching files deleted with rc =' rc 

say 'logoff:' ftp~logoff                -- logoff from server
exit 0 

::REQUIRES "xftp.cls" 