#! /usr/local/orexx/bin/rexx
/****************************************************************************/
/* Name:        tdel.cmd                                                    */
/* Function:    Delete whole directory tree                                 */
/* Type:        Object REXX Script                                          */     
/*                                                                          */     
/* Requirement: xFtp.cls and ftp framework ftp.frm                          */
/****************************************************************************/      
curmode = .false
 
ftp = .xFtp~new                         -- create ftp object
ftp~debug = .true                       -- request debug messages 
                                        -- connect to server
if ftp~connect('host', 'userid', 'password') \= 0 then exit 
say ftp~sys(sys)                        -- determine ftp-server type
say 'remote slash' ftp~rslash           -- remote slash   

if curmode then do
  /*------------------------------------------------------------------------*/
  /* Delete the contents of directory                                       */
  /*------------------------------------------------------------------------*/
  ftp~cd('deldir')
  say 'current remote directory:' ftp~pwd
  say
  rc = ftp~getdirlist()                 -- show what's in there
  if rc \= -1 & rc \= 0 then do
    say 'files/directories found in current directory "deldir":'
    do entry over rc; say entry; end
  end 
  else signal error

  say '-----tdel()----------------'
  say 'delete all files/directories from the current remote directory'      
  rc = ftp~tdel() 
  say 'remote files/directories deleted with rc =' rc 
end 
else do
  /*------------------------------------------------------------------------*/
  /* Delete the directory with its contents                                 */
  /*------------------------------------------------------------------------*/
  say 'remote dir:' ftp~pwd
  rc = ftp~getdirlist('deldir')          -- show what's in there     
  if rc \= -1 & rc \= 0 then do
    say 'files/directories found in "deldir":'
    do entry over rc; say entry; end
  end 
  else signal error

  say '-----tdel(dir)-------------'
  say 'delete the remote directory "deldir" and all its subdirectories'      
  rc = ftp~tdel('deldir') 
  say 'remote directory deleted with rc =' rc 
end
say '---------------------------'

error:
  say 'logoff:' ftp~logoff              -- logoff from server            
  exit 0

::REQUIRES "xftp.cls"                        