/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

class hlcjXPicture {
    JDialog pf;
    RandomAccessFile myBook;
    String DesPic = new String();
    int picWidth = 0;
    int picHeight = 0;
    static final String fsep = new String(System.getProperty("file.separator"));
    static final char fsepChar = fsep.charAt(0);
    private boolean picIsOpen = false;
    Rectangle picSize = null;
    String runDir;
    String errorMessage;

    hlcjXPicture() {
    }

    public void setRunDir(String string) {
        this.runDir = new String(string);
    }

    public int getPicture(String string, String string2, Dimension dimension) {
        boolean bl = false;
        String string3 = new String(string.replace(fsepChar, '_'));
        if (string3.indexOf(":") >= 0) {
            string3 = string3.substring(0, string3.indexOf(":")) + string3.substring(string3.indexOf(":") + 1);
        }
        if (!this.checkPictureExists(string3 = this.runDir + "cache" + fsep + string2 + "_" + string3)) {
            try {
                this.myBook = new RandomAccessFile(string, "r");
                int n = this.myBook.readUnsignedShort();
                long l = this.myBook.getFilePointer();
                this.myBook.seek(n *= 4096);
                long l2 = this.myBook.readLong();
                int n2 = this.myBook.readUnsignedByte();
                int n3 = this.myBook.readUnsignedByte();
                int n4 = this.myBook.readUnsignedByte();
                this.myBook.seek(l);
                int n5 = this.myBook.readUnsignedShort();
                int n6 = this.myBook.readInt();
                this.myBook.close();
                if (n3 == 0 || n4 == 3) {
                    if (!System.getProperty("os.name").toUpperCase().startsWith("LINUX")) {
                        hlccallGraphics hlccallGraphics2 = new hlccallGraphics(string, string2, string3, n6, this.getPicInfoOffset(n3, n4, n6));
                        int n7 = hlccallGraphics2.convertPicture();
                        if (n7 == 0) {
                            this.DesPic = string3 + ".gif";
                            this.extractSize();
                            this.picSize = new Rectangle(this.picWidth, this.picHeight);
                        }
                        return n7;
                    }
                    this.errorMessage = "Graphics conversion not supported.";
                    return -1;
                }
                if (n3 == 1 && n4 == 0) {
                    hlcjXObj hlcjXObj2 = new hlcjXObj(string, string2, string3, n6, dimension);
                    int n8 = hlcjXObj2.extractPicture();
                    if (n8 != 0) {
                        if (n8 == -1) {
                            this.errorMessage = "Unsupported picture type.";
                            return n8;
                        }
                        if (n5 == -2) {
                            this.errorMessage = "Unable to locate picture.";
                            return n8;
                        }
                        this.errorMessage = "Unable to create picture object.";
                        return n8;
                    }
                    this.picSize = hlcjXObj2.getWebObjectHW();
                    this.DesPic = hlcjXObj2.getObjName();
                    if (hlcjXObj2.missingDimensions) {
                        this.errorMessage = "Missing picture dimensions.";
                        return -1;
                    }
                    return n8;
                }
                this.errorMessage = "Unknown Book Architecture.";
                return -1;
            }
            catch (IOException iOException) {
                this.errorMessage = "Error converting picture.";
                return -1;
            }
        }
        return 11;
    }

    public boolean isOpen() {
        return this.picIsOpen;
    }

    public Rectangle getPicSize(Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        if (this.picHeight * this.picWidth == 0) {
            this.extractSize();
        }
        Rectangle rectangle3 = new Rectangle(this.picWidth, this.picHeight);
        if (!(!bl || rectangle3.contains(rectangle) && rectangle2.contains(rectangle3))) {
            if (rectangle3.contains(rectangle)) {
                double d = Math.min(rectangle2.getWidth() / rectangle3.getWidth(), rectangle2.getHeight() / rectangle3.getHeight());
                rectangle3.setRect(0.0, 0.0, (double)this.picWidth * d, (double)this.picHeight * d);
            } else {
                double d = Math.max(rectangle.getWidth() / rectangle3.getWidth(), rectangle.getHeight() / rectangle3.getHeight());
                rectangle3.setRect(0.0, 0.0, (double)this.picWidth * d, (double)this.picHeight * d);
            }
        }
        return rectangle3;
    }

    public Rectangle scalePicSize(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        Rectangle rectangle4 = new Rectangle(rectangle3);
        this.picWidth = (int)rectangle4.getWidth();
        this.picHeight = (int)rectangle4.getHeight();
        if (!rectangle4.contains(rectangle) || !rectangle2.contains(rectangle4)) {
            if (rectangle4.contains(rectangle)) {
                double d = Math.min(rectangle2.getWidth() / rectangle4.getWidth(), rectangle2.getHeight() / rectangle4.getHeight());
                rectangle4.setRect(0.0, 0.0, (double)this.picWidth * d, (double)this.picHeight * d);
            } else {
                double d = Math.max(rectangle.getWidth() / rectangle4.getWidth(), rectangle.getHeight() / rectangle4.getHeight());
                rectangle4.setRect(0.0, 0.0, (double)this.picWidth * d, (double)this.picHeight * d);
            }
        }
        return rectangle4;
    }

    public String getPictureLocName() {
        return this.DesPic;
    }

    private boolean checkPictureExists(String string) {
        File file = new File(string + ".gif");
        this.DesPic = string + ".gif";
        if (file.exists() && file.length() > 0L) {
            return true;
        }
        File file2 = new File(string + ".jpg");
        if (file2.exists() && file2.length() > 0L) {
            this.DesPic = string + ".jpg";
            return true;
        }
        File file3 = new File(string + ".png");
        if (file3.exists() && file3.length() > 0L) {
            this.DesPic = string + ".png";
            return true;
        }
        return false;
    }

    private void extractSize() {
        if (this.DesPic.endsWith(".gif")) {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.DesPic, "r");
                randomAccessFile.seek(10L);
                int n = randomAccessFile.readUnsignedByte();
                int n2 = 0;
                if ((n & 0x80) != 0) {
                    n2 = (1 << (n & 7) + 1) * 3 + 13;
                }
                randomAccessFile.seek(n2);
                int n3 = randomAccessFile.readUnsignedByte();
                if (n3 == 33) {
                    randomAccessFile.seek((long)n2 + 2L);
                    int n4 = randomAccessFile.readUnsignedByte();
                    randomAccessFile.seek(n2 += 4 + n4);
                    n3 = randomAccessFile.readUnsignedByte();
                }
                if (n3 == 44) {
                    randomAccessFile.seek((long)n2 + 5L);
                    this.picWidth = randomAccessFile.readUnsignedByte() + 256 * randomAccessFile.readUnsignedByte();
                    this.picHeight = randomAccessFile.readUnsignedByte() + 256 * randomAccessFile.readUnsignedByte();
                }
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "Error reading picture information.", "IBM Softcopy Reader", 0);
            }
        } else if (this.DesPic.endsWith(".jpg")) {
            try {
                int n;
                boolean bl = false;
                boolean bl2 = false;
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.DesPic, "r");
                while (!bl) {
                    n = randomAccessFile.readUnsignedByte();
                    if (n != 255 || (n = randomAccessFile.readUnsignedByte()) != 219) continue;
                    bl = true;
                }
                while (!bl2) {
                    n = randomAccessFile.readUnsignedByte();
                    if (n != 255 || (n = randomAccessFile.readUnsignedByte()) != 192) continue;
                    bl2 = true;
                }
                n = randomAccessFile.readUnsignedByte();
                n = randomAccessFile.readUnsignedByte();
                n = randomAccessFile.readUnsignedByte();
                n = randomAccessFile.readUnsignedByte();
                this.picHeight = n * 256 + randomAccessFile.readUnsignedByte();
                n = randomAccessFile.readUnsignedByte();
                this.picWidth = n * 256 + randomAccessFile.readUnsignedByte();
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "Error reading picture information.", "IBM Softcopy Reader", 0);
            }
        }
    }

    public void showPic(JFrame jFrame, Rectangle rectangle) {
        this.pf = new JDialog((Frame)jFrame, this.DesPic);
        this.pf.setTitle("IBM Softcopy Reader");
        ImageIcon imageIcon = new ImageIcon(this.DesPic);
        int n = (int)rectangle.getWidth();
        int n2 = (int)rectangle.getHeight();
        ImageIcon imageIcon2 = new ImageIcon(imageIcon.getImage().getScaledInstance(n, n2, 4));
        JLabel jLabel = new JLabel(imageIcon2);
        jLabel.setLocation(5, 15);
        jLabel.setSize(n, n2);
        this.pf.getContentPane().add(jLabel);
        this.pf.setSize(n + 10, n2 + 30);
        this.pf.setLocationRelativeTo(jFrame);
        this.pf.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    hlcjXPicture.this.pf.setVisible(false);
                    hlcjXPicture.this.picIsOpen = false;
                    hlcjXPicture.this.pf.dispose();
                }
            }
        });
        this.pf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                hlcjXPicture.this.pf.setVisible(false);
                hlcjXPicture.this.picIsOpen = false;
                hlcjXPicture.this.pf.dispose();
            }
        });
        this.pf.setVisible(true);
        this.picIsOpen = true;
    }

    private int getPicInfoOffset(int n, int n2, int n3) {
        if (n == 1 && n2 == 3) {
            return 280 + n3 * 16;
        }
        return 280;
    }
}

