/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class hlcconfig {
    static final String fsep = new String(System.getProperty("file.separator"));
    final String configFile;
    final String NOTES_SEARCH_PATH = new String("Notes Search Path");
    final String BOOK_SEARCH_PATH = new String("Book Search Path");
    protected String userDataDirectory = "";
    protected String runDir = "";
    String sDir = new String();
    String winRoot;

    public void copyFile(File in, File out) throws Exception {
        FileChannel sourceChannel = new FileInputStream(in).getChannel();
        FileChannel destinationChannel = new FileOutputStream(out).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
        sourceChannel.close();
        destinationChannel.close();
    }

    public hlcconfig(String runDir, String userDataDirectoryIn, String sD, JFrame frame) {
        this.userDataDirectory = userDataDirectoryIn;
        this.sDir = sD;
        String defaultBookmgrIniFileName = runDir + "bookmgr.ini";
        String userBookmgrIniFileName = this.userDataDirectory + "bookmgr.ini";
        File cfile = new File(userBookmgrIniFileName);
        if (!cfile.exists()) {
            try {
                File defaultBookmgrIniFile = new File(defaultBookmgrIniFileName);
                if (defaultBookmgrIniFile.exists()) {
                    this.copyFile(defaultBookmgrIniFile, cfile);
                } else {
                    System.out.println("Cannot find default bookmgr.ini file.");
                }
            }
            catch (Exception e) {
                System.out.println("Error copying default bookmgr.ini file to user data directory.");
                e.printStackTrace();
            }
        }
        this.configFile = this.userDataDirectory + "bookmgr.ini";
        if (!cfile.exists()) {
            int selectedValue = JOptionPane.showConfirmDialog(frame, "Configuration file not found. \nWould you like to create the file now?", "IBM Softcopy Reader", 0, 3);
            if (selectedValue == 0) {
                if (!this.createConfigFile(cfile, this.userDataDirectory, frame)) {
                    JOptionPane.showMessageDialog(frame, "Could not create configuration file BOOKMGR.INI.", "IBM Softcopy Reader", 0);
                    System.exit(0);
                }
            } else {
                JOptionPane.showMessageDialog(frame, "You first must create a configuration file.", "IBM Softcopy Reader", 0);
                System.exit(0);
            }
        }
    }

    private boolean createConfigFile(File configFile, String cDir, JFrame frame) {
        boolean success = true;
        try {
            File configDirectory = new File(cDir);
            if (!configDirectory.exists()) {
                configDirectory.mkdirs();
            }
            configFile.createNewFile();
            FileWriter configWriter = new FileWriter(configFile);
            configWriter.write("IBM Softcopy Reader\n");
            configWriter.write(this.BOOK_SEARCH_PATH + "=" + cDir + "\n");
            configWriter.write(this.NOTES_SEARCH_PATH + "=" + cDir + "\n");
            configWriter.close();
            hlcjloc jl = new hlcjloc(this.runDir, this.userDataDirectory, frame);
        }
        catch (IOException e) {
            System.out.println(e.toString());
            System.out.println("Error creating config file " + configFile.getAbsolutePath());
            JOptionPane.showMessageDialog(null, "Could not create configuration file BOOKMGR.INI.", "IBM Softcopy Reader", 0);
            System.exit(0);
        }
        return success;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vector parsePath(String allTogetherPath, boolean valid) {
        StringTokenizer pathTokens = new StringTokenizer(allTogetherPath, ";");
        HashSet<String> uniqueDirectories = new HashSet<String>();
        boolean isUnique = false;
        Vector<String> pathVector = new Vector<String>();
        int m = pathTokens.countTokens();
        if (m > 0) {
            for (int k = 0; k < m; ++k) {
                String nextPath = new String(pathTokens.nextToken().trim());
                if (nextPath == null || nextPath == "") continue;
                File testFile = new File(nextPath);
                try {
                    isUnique = uniqueDirectories.add(testFile.getCanonicalPath());
                    if (!isUnique || !testFile.exists() && valid) continue;
                    pathVector.addElement(testFile.getCanonicalPath());
                    continue;
                }
                catch (IOException e) {
                    System.out.println("IO Exception while attempting to get canonical File");
                    isUnique = false;
                }
            }
            return pathVector;
        } else {
            File testFile = new File(this.userDataDirectory);
            try {
                String canonicalPath = testFile.getCanonicalPath();
                isUnique = uniqueDirectories.add(canonicalPath);
                if (!isUnique || !testFile.exists() && valid) return pathVector;
                pathVector.addElement(testFile.getCanonicalPath());
                return pathVector;
            }
            catch (IOException e) {
                System.out.println("IO Exception while attempting to get canonical File");
                return pathVector;
            }
        }
    }

    public boolean changeBookPath(String newPath) {
        return this.writeVar(this.BOOK_SEARCH_PATH, newPath);
    }

    public Vector getBookPath(boolean valid) {
        Vector confVector = this.parsePath(this.seekVar(this.BOOK_SEARCH_PATH), valid);
        if (this.sDir.length() > 0) {
            boolean found = false;
            int index = this.sDir.lastIndexOf(fsep);
            if (index != -1) {
                String sDirPath = this.sDir.substring(0, index);
                for (int i = 0; !found && i < confVector.size(); ++i) {
                    if (!sDirPath.equalsIgnoreCase((String)confVector.elementAt(i))) continue;
                    found = true;
                }
                if (!found) {
                    // empty if block
                }
            }
        }
        return confVector;
    }

    public Vector getNotesPath(boolean valid) {
        return this.parsePath(this.seekVar(this.NOTES_SEARCH_PATH), valid);
    }

    public String getNotesPathString() {
        return this.seekVar(this.NOTES_SEARCH_PATH);
    }

    public boolean changeNotesPath(String newPath) {
        return this.writeVar(this.NOTES_SEARCH_PATH, newPath);
    }

    public boolean writeVar(String configVar, String value) {
        String configLine = new String(".");
        try {
            File iFile = new File(this.configFile);
            String temporaryFileName = this.userDataDirectory + "bookmgr.ini.temp";
            File tFile = new File(temporaryFileName);
            FileOutputStream ostream = new FileOutputStream(tFile);
            PrintStream newConf = new PrintStream(ostream, true);
            RandomAccessFile oldConf = new RandomAccessFile(iFile, "r");
            configLine = oldConf.readLine();
            while (configLine != null) {
                if (configLine.startsWith(configVar)) {
                    newConf.println(configVar + "=" + value);
                } else {
                    newConf.println(configLine);
                }
                configLine = oldConf.readLine();
            }
            newConf.close();
            oldConf.close();
            iFile.delete();
            tFile.renameTo(iFile);
            return true;
        }
        catch (IOException doh) {
            JOptionPane.showMessageDialog(null, "Error writing to configuration file.", "IBM Softcopy Reader", 0);
            return false;
        }
    }

    public String seekVar(String configVar) {
        String configLine = new String();
        try {
            RandomAccessFile myConf = new RandomAccessFile(this.configFile, "r");
            configLine = myConf.readLine();
            while (configLine != null && !configLine.startsWith(configVar)) {
                configLine = myConf.readLine();
            }
            myConf.close();
        }
        catch (IOException doh) {
            doh.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error reading from configuration file.", "IBM Softcopy Reader", 2);
        }
        if (configLine != null && configLine.length() > configVar.length()) {
            return configLine.substring(configVar.length() + 1);
        }
        return "";
    }
}

