/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.lang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.util.Calendar;

public class Debug {
    protected static PrintWriter writer;
    protected static String OSName;
    protected static String OSVersion;
    protected static String OSPlatform;

    protected Debug() {
    }

    public static synchronized boolean setWriter(String fileName, Object clazz, String version) throws IOException {
        return Debug.setWriter(new File(fileName), clazz, version);
    }

    public static synchronized boolean setWriter(URL url, Object clazz, String version) throws IOException {
        return Debug.setWriter(url.getFile(), clazz, version);
    }

    public static synchronized boolean setWriter(File file, Object clazz, String version) throws IOException {
        return Debug.setWriter(new FileWriter(file), clazz, version);
    }

    public static synchronized boolean setWriter(OutputStream stream, Object clazz, String version) {
        return Debug.setWriter(new OutputStreamWriter(stream), clazz, version);
    }

    public static synchronized boolean setWriter(Writer w, Object clazz, String version) {
        if (writer == null) {
            writer = new PrintWriter(w, true);
            writer.println("OS Information:");
            writer.println("   - OS          : " + OSName);
            writer.println("   - Version     : " + OSVersion);
            writer.println("   - Platform    : " + OSPlatform);
            writer.println("   - JDK Version : " + System.getProperty("java.version"));
            writer.println("   - JDK Vendor  : " + System.getProperty("java.vendor"));
            writer.println();
            writer.println("Program Information:");
            writer.println("   - Main Class : " + clazz.getClass().getName());
            writer.println("   - Version    : " + version);
            writer.println();
            writer.println("Start of debugging log - Time: " + DateFormat.getDateTimeInstance(0, 0).format(Calendar.getInstance().getTime()));
            writer.println();
            return true;
        }
        return false;
    }

    public static synchronized void write(String msg) {
        if (writer != null) {
            writer.println(msg);
        }
    }

    public static synchronized void write(Object src, long line, String msg) {
        if (writer != null) {
            writer.println(String.valueOf(src.getClass().getName()) + " :: " + Debug.convertLineNumber(line) + " :: " + msg);
        }
    }

    public static synchronized void write(Object src, long line, String action, String result) {
        if (writer != null) {
            writer.println(String.valueOf(src.getClass().getName()) + " :: " + Debug.convertLineNumber(line) + " :: " + action + " :: " + result);
        }
    }

    public static synchronized void write(Object src, long line, Throwable ex) {
        if (writer != null) {
            writer.println(String.valueOf(src.getClass().getName()) + " :: " + Debug.convertLineNumber(line) + " :: " + ex.getMessage());
            ex.printStackTrace(writer);
        }
    }

    public static synchronized void finish() {
        writer.println();
        writer.println("End of debugging log - Time: " + DateFormat.getDateTimeInstance(0, 0).format(Calendar.getInstance().getTime()));
        writer.close();
    }

    public static synchronized long getLineNumber() {
        Throwable stackTrace = new Throwable().fillInStackTrace();
        StringWriter writer = new StringWriter();
        stackTrace.printStackTrace(new PrintWriter(writer));
        BufferedReader reader = new BufferedReader(new StringReader(writer.toString()));
        try {
            reader.readLine();
            reader.readLine();
            String line = reader.readLine();
            if (line != null) {
                line = line.substring(line.lastIndexOf(58) + 1, line.length() - 1);
                return Long.parseLong(line);
            }
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {}
        return -1L;
    }

    private static String convertLineNumber(long line) {
        if (line == -1L) {
            return "Unknown line";
        }
        return Long.toString(line);
    }

    static {
        OSName = System.getProperty("os.name");
        OSVersion = System.getProperty("os.version");
        OSPlatform = System.getProperty("os.arch");
    }
}

