/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/
#ifndef HWSDMOD_HPP
#define HWSDMOD_HPP

#include "hws.h"
#include "hwstout.hpp"

class HWSDList;

class DllExport HWSErrOut : public HWSTranOut {

   public:

      HWSErrOut(HWSDList * fldList);
      HWSErrOut(int errNum, char * errMsg);
      ~HWSErrOut();

      // Overloaded Method
      virtual char   * genHTML();
      virtual HWSLNode * genList();

      // Access Methods for Fields
      inline char * geterrCode()    {return(errCode);};
      inline char * geterrString()  {return(errString);};
      inline char * geterrBuffer()  {return(errBuffer);};
	
   private:

      char * errCode;
      char * errString;
      char * errBuffer;
};

#define HWSMO1_MAX_OUTLINE		119

class DllExport HWSMO1 : public HWSTranOut {

	public:

		// LifeCycle
		HWSMO1(HWSDList * fldList);
		~HWSMO1();

		// Overloaded Method
		virtual char     * genHTML();
		virtual HWSLNode * genList();

		inline char * getOUTLINE()    {return(OUTLINE);};

	private:

		HWSDList * fList;

		char OUTLINE[HWSMO1_MAX_OUTLINE+1];

};

#define HWSMO2_MAX_OUTL01		119
#define HWSMO2_MAX_OUTL02		119
#define HWSMO2_MAX_OUTL03		119
#define HWSMO2_MAX_OUTL04		119
#define HWSMO2_MAX_OUTL05		119
#define HWSMO2_MAX_OUTL06		119
#define HWSMO2_MAX_OUTL07		119
#define HWSMO2_MAX_OUTL08		119
#define HWSMO2_MAX_OUTL09		119
#define HWSMO2_MAX_OUTL10		119
#define HWSMO2_MAX_OUTL11		119
#define HWSMO2_MAX_OUTL12		119
#define HWSMO2_MAX_OUTL13		119
#define HWSMO2_MAX_OUTL14		119
#define HWSMO2_MAX_OUTL15		119
#define HWSMO2_MAX_OUTL16		119
#define HWSMO2_MAX_OUTL17		119
#define HWSMO2_MAX_OUTL18		119
#define HWSMO2_MAX_OUTL19		119
#define HWSMO2_MAX_OUTL20		119
#define HWSMO2_MAX_OUTL21		119
#define HWSMO2_MAX_OUTL22		119

class DllExport HWSMO2 : public HWSTranOut {

	public:

		// LifeCycle
		HWSMO2(HWSDList * fldList);
		~HWSMO2();

		// Overloaded Method
		virtual char     * genHTML();
		virtual HWSLNode * genList();

		// Access Methods for Fields
		inline char * getOUTL01()    {return(OUTL01);};
		inline char * getOUTL02()    {return(OUTL02);};
		inline char * getOUTL03()    {return(OUTL03);};
		inline char * getOUTL04()    {return(OUTL04);};
		inline char * getOUTL05()    {return(OUTL05);};
		inline char * getOUTL06()    {return(OUTL06);};
		inline char * getOUTL07()    {return(OUTL07);};
		inline char * getOUTL08()    {return(OUTL08);};
		inline char * getOUTL09()    {return(OUTL09);};
		inline char * getOUTL10()    {return(OUTL10);};
		inline char * getOUTL11()    {return(OUTL11);};
		inline char * getOUTL12()    {return(OUTL12);};
		inline char * getOUTL13()    {return(OUTL13);};
		inline char * getOUTL14()    {return(OUTL14);};
		inline char * getOUTL15()    {return(OUTL15);};
		inline char * getOUTL16()    {return(OUTL16);};
		inline char * getOUTL17()    {return(OUTL17);};
		inline char * getOUTL18()    {return(OUTL18);};
		inline char * getOUTL19()    {return(OUTL19);};
		inline char * getOUTL20()    {return(OUTL20);};
		inline char * getOUTL21()    {return(OUTL21);};
		inline char * getOUTL22()    {return(OUTL22);};

	private:

		HWSDList * fList;

		char OUTL01[HWSMO2_MAX_OUTL01+1];
		char OUTL02[HWSMO2_MAX_OUTL02+1];
		char OUTL03[HWSMO2_MAX_OUTL03+1];
		char OUTL04[HWSMO2_MAX_OUTL04+1];
		char OUTL05[HWSMO2_MAX_OUTL05+1];
		char OUTL06[HWSMO2_MAX_OUTL06+1];
		char OUTL07[HWSMO2_MAX_OUTL07+1];
		char OUTL08[HWSMO2_MAX_OUTL08+1];
		char OUTL09[HWSMO2_MAX_OUTL09+1];
		char OUTL10[HWSMO2_MAX_OUTL10+1];
		char OUTL11[HWSMO2_MAX_OUTL11+1];
		char OUTL12[HWSMO2_MAX_OUTL12+1];
		char OUTL13[HWSMO2_MAX_OUTL13+1];
		char OUTL14[HWSMO2_MAX_OUTL14+1];
		char OUTL15[HWSMO2_MAX_OUTL15+1];
		char OUTL16[HWSMO2_MAX_OUTL16+1];
		char OUTL17[HWSMO2_MAX_OUTL17+1];
		char OUTL18[HWSMO2_MAX_OUTL18+1];
		char OUTL19[HWSMO2_MAX_OUTL19+1];
		char OUTL20[HWSMO2_MAX_OUTL20+1];
		char OUTL21[HWSMO2_MAX_OUTL21+1];
		char OUTL22[HWSMO2_MAX_OUTL22+1];
};

#define HWSMO3_MAX_OUTL01		38
#define HWSMO3_MAX_OUTL02		119
#define HWSMO3_MAX_OUTL03		119
#define HWSMO3_MAX_OUTL04		119
#define HWSMO3_MAX_OUTL05		119
#define HWSMO3_MAX_OUTL06		119
#define HWSMO3_MAX_OUTL07		119
#define HWSMO3_MAX_OUTL08		119
#define HWSMO3_MAX_OUTL09		119
#define HWSMO3_MAX_OUTL10		119
#define HWSMO3_MAX_OUTL11		119
#define HWSMO3_MAX_OUTL12		119
#define HWSMO3_MAX_OUTL13		119
#define HWSMO3_MAX_OUTL14		119
#define HWSMO3_MAX_OUTL15		119
#define HWSMO3_MAX_OUTL16		119
#define HWSMO3_MAX_OUTL17		119
#define HWSMO3_MAX_OUTL18		119
#define HWSMO3_MAX_OUTL19		119
#define HWSMO3_MAX_OUTL20		119
#define HWSMO3_MAX_OUTL21		119
#define HWSMO3_MAX_OUTL22		119

class DllExport HWSMO3 : public HWSTranOut {

	public:

		// LifeCycle
		HWSMO3(HWSDList * fldList);
		~HWSMO3();

		// Overloaded Method
		virtual char     * genHTML();
		virtual HWSLNode * genList();

		// Access Methods for Fields
		inline char * getOUTL01()    {return(OUTL01);};
		inline char * getOUTL02()    {return(OUTL02);};
		inline char * getOUTL03()    {return(OUTL03);};
		inline char * getOUTL04()    {return(OUTL04);};
		inline char * getOUTL05()    {return(OUTL05);};
		inline char * getOUTL06()    {return(OUTL06);};
		inline char * getOUTL07()    {return(OUTL07);};
		inline char * getOUTL08()    {return(OUTL08);};
		inline char * getOUTL09()    {return(OUTL09);};
		inline char * getOUTL10()    {return(OUTL10);};
		inline char * getOUTL11()    {return(OUTL11);};
		inline char * getOUTL12()    {return(OUTL12);};
		inline char * getOUTL13()    {return(OUTL13);};
		inline char * getOUTL14()    {return(OUTL14);};
		inline char * getOUTL15()    {return(OUTL15);};
		inline char * getOUTL16()    {return(OUTL16);};
		inline char * getOUTL17()    {return(OUTL17);};
		inline char * getOUTL18()    {return(OUTL18);};
		inline char * getOUTL19()    {return(OUTL19);};
		inline char * getOUTL20()    {return(OUTL20);};
		inline char * getOUTL21()    {return(OUTL21);};
		inline char * getOUTL22()    {return(OUTL22);};

	private:

		HWSDList * fList;

		char OUTL01[HWSMO3_MAX_OUTL01+1];
		char OUTL02[HWSMO3_MAX_OUTL02+1];
		char OUTL03[HWSMO3_MAX_OUTL03+1];
		char OUTL04[HWSMO3_MAX_OUTL04+1];
		char OUTL05[HWSMO3_MAX_OUTL05+1];
		char OUTL06[HWSMO3_MAX_OUTL06+1];
		char OUTL07[HWSMO3_MAX_OUTL07+1];
		char OUTL08[HWSMO3_MAX_OUTL08+1];
		char OUTL09[HWSMO3_MAX_OUTL09+1];
		char OUTL10[HWSMO3_MAX_OUTL10+1];
		char OUTL11[HWSMO3_MAX_OUTL11+1];
		char OUTL12[HWSMO3_MAX_OUTL12+1];
		char OUTL13[HWSMO3_MAX_OUTL13+1];
		char OUTL14[HWSMO3_MAX_OUTL14+1];
		char OUTL15[HWSMO3_MAX_OUTL15+1];
		char OUTL16[HWSMO3_MAX_OUTL16+1];
		char OUTL17[HWSMO3_MAX_OUTL17+1];
		char OUTL18[HWSMO3_MAX_OUTL18+1];
		char OUTL19[HWSMO3_MAX_OUTL19+1];
		char OUTL20[HWSMO3_MAX_OUTL20+1];
		char OUTL21[HWSMO3_MAX_OUTL21+1];
		char OUTL22[HWSMO3_MAX_OUTL22+1];
};

#define HWSMO4_MAX_DF01		119
#define HWSMO4_MAX_DF02		119
#define HWSMO4_MAX_DF03		119
#define HWSMO4_MAX_DF04		119

class DllExport HWSMO4 : public HWSTranOut {

	public:

		// LifeCycle
		HWSMO4(HWSDList * fldList);
		~HWSMO4();

		// Overloaded Method
		virtual char     * genHTML();
		virtual HWSLNode * genList();

		// Access Methods for Fields
		inline char * getDF01()    {return(DF01);};
		inline char * getDF02()    {return(DF02);};
		inline char * getDF03()    {return(DF03);};
		inline char * getDF04()    {return(DF04);};

	private:

		HWSDList * fList;

		char DF01[HWSMO4_MAX_DF01+1];
		char DF02[HWSMO4_MAX_DF02+1];
		char DF03[HWSMO4_MAX_DF03+1];
		char DF04[HWSMO4_MAX_DF04+1];
};

#define HWSMO5_MAX_OUTL01		119
#define HWSMO5_MAX_OUTL02		119
#define HWSMO5_MAX_OUTL03		119
#define HWSMO5_MAX_OUTL04		119
#define HWSMO5_MAX_OUTL05		119
#define HWSMO5_MAX_OUTL06		119
#define HWSMO5_MAX_OUTL07		119
#define HWSMO5_MAX_OUTL08		119
#define HWSMO5_MAX_OUTL09		119
#define HWSMO5_MAX_OUTL10		119
#define HWSMO5_MAX_OUTL11		119
#define HWSMO5_MAX_OUTL12		119
#define HWSMO5_MAX_OUTL13		119
#define HWSMO5_MAX_OUTL14		119
#define HWSMO5_MAX_OUTL15		119
#define HWSMO5_MAX_OUTL16		119
#define HWSMO5_MAX_OUTL17		119
#define HWSMO5_MAX_OUTL18		119
#define HWSMO5_MAX_OUTL19		119
#define HWSMO5_MAX_OUTL20		119
#define HWSMO5_MAX_OUTL21		119
#define HWSMO5_MAX_OUTL22		119

class DllExport HWSMO5 : public HWSTranOut {

	public:

		// LifeCycle
		HWSMO5(HWSDList * fldList);
		~HWSMO5();

		// Overloaded Method
		virtual char     * genHTML();
		virtual HWSLNode * genList();

		// Access Methods for Fields
		inline char * getOUTL01()    {return(OUTL01);};
		inline char * getOUTL02()    {return(OUTL02);};
		inline char * getOUTL03()    {return(OUTL03);};
		inline char * getOUTL04()    {return(OUTL04);};
		inline char * getOUTL05()    {return(OUTL05);};
		inline char * getOUTL06()    {return(OUTL06);};
		inline char * getOUTL07()    {return(OUTL07);};
		inline char * getOUTL08()    {return(OUTL08);};
		inline char * getOUTL09()    {return(OUTL09);};
		inline char * getOUTL10()    {return(OUTL10);};
		inline char * getOUTL11()    {return(OUTL11);};
		inline char * getOUTL12()    {return(OUTL12);};
		inline char * getOUTL13()    {return(OUTL13);};
		inline char * getOUTL14()    {return(OUTL14);};
		inline char * getOUTL15()    {return(OUTL15);};
		inline char * getOUTL16()    {return(OUTL16);};
		inline char * getOUTL17()    {return(OUTL17);};
		inline char * getOUTL18()    {return(OUTL18);};
		inline char * getOUTL19()    {return(OUTL19);};
		inline char * getOUTL20()    {return(OUTL20);};
		inline char * getOUTL21()    {return(OUTL21);};
		inline char * getOUTL22()    {return(OUTL22);};

	private:

		HWSDList * fList;

		char OUTL01[HWSMO5_MAX_OUTL01+1];
		char OUTL02[HWSMO5_MAX_OUTL02+1];
		char OUTL03[HWSMO5_MAX_OUTL03+1];
		char OUTL04[HWSMO5_MAX_OUTL04+1];
		char OUTL05[HWSMO5_MAX_OUTL05+1];
		char OUTL06[HWSMO5_MAX_OUTL06+1];
		char OUTL07[HWSMO5_MAX_OUTL07+1];
		char OUTL08[HWSMO5_MAX_OUTL08+1];
		char OUTL09[HWSMO5_MAX_OUTL09+1];
		char OUTL10[HWSMO5_MAX_OUTL10+1];
		char OUTL11[HWSMO5_MAX_OUTL11+1];
		char OUTL12[HWSMO5_MAX_OUTL12+1];
		char OUTL13[HWSMO5_MAX_OUTL13+1];
		char OUTL14[HWSMO5_MAX_OUTL14+1];
		char OUTL15[HWSMO5_MAX_OUTL15+1];
		char OUTL16[HWSMO5_MAX_OUTL16+1];
		char OUTL17[HWSMO5_MAX_OUTL17+1];
		char OUTL18[HWSMO5_MAX_OUTL18+1];
		char OUTL19[HWSMO5_MAX_OUTL19+1];
		char OUTL20[HWSMO5_MAX_OUTL20+1];
		char OUTL21[HWSMO5_MAX_OUTL21+1];
		char OUTL22[HWSMO5_MAX_OUTL22+1];
};


#define HWSDSPO1_MAX_OUTL01		119
#define HWSDSPO1_MAX_OUTL02		119
#define HWSDSPO1_MAX_OUTL03		119
#define HWSDSPO1_MAX_OUTL04		119
#define HWSDSPO1_MAX_OUTL05		119
#define HWSDSPO1_MAX_OUTL06		119
#define HWSDSPO1_MAX_OUTL07		119
#define HWSDSPO1_MAX_OUTL08		119
#define HWSDSPO1_MAX_OUTL09		119
#define HWSDSPO1_MAX_OUTL10		119
#define HWSDSPO1_MAX_OUTL11		119
#define HWSDSPO1_MAX_OUTL12		119
#define HWSDSPO1_MAX_OUTL13		119
#define HWSDSPO1_MAX_OUTL14		119
#define HWSDSPO1_MAX_OUTL15		119
#define HWSDSPO1_MAX_OUTL16		119
#define HWSDSPO1_MAX_OUTL17		119
#define HWSDSPO1_MAX_OUTL18		119
#define HWSDSPO1_MAX_OUTL19		119
#define HWSDSPO1_MAX_OUTL20		119
#define HWSDSPO1_MAX_OUTL21		119
#define HWSDSPO1_MAX_OUTL22		119

class DllExport HWSDSPO1 : public HWSTranOut {

	public:

		// LifeCycle
		HWSDSPO1(HWSDList * fldList);
		~HWSDSPO1();

		// Overloaded Method
		virtual char     * genHTML();
		virtual HWSLNode * genList();

		// Access Methods for Fields
		inline char * getOUTL01()    {return(OUTL01);};
		inline char * getOUTL02()    {return(OUTL02);};
		inline char * getOUTL03()    {return(OUTL03);};
		inline char * getOUTL04()    {return(OUTL04);};
		inline char * getOUTL05()    {return(OUTL05);};
		inline char * getOUTL06()    {return(OUTL06);};
		inline char * getOUTL07()    {return(OUTL07);};
		inline char * getOUTL08()    {return(OUTL08);};
		inline char * getOUTL09()    {return(OUTL09);};
		inline char * getOUTL10()    {return(OUTL10);};
		inline char * getOUTL11()    {return(OUTL11);};
		inline char * getOUTL12()    {return(OUTL12);};
		inline char * getOUTL13()    {return(OUTL13);};
		inline char * getOUTL14()    {return(OUTL14);};
		inline char * getOUTL15()    {return(OUTL15);};
		inline char * getOUTL16()    {return(OUTL16);};
		inline char * getOUTL17()    {return(OUTL17);};
		inline char * getOUTL18()    {return(OUTL18);};
		inline char * getOUTL19()    {return(OUTL19);};
		inline char * getOUTL20()    {return(OUTL20);};
		inline char * getOUTL21()    {return(OUTL21);};
		inline char * getOUTL22()    {return(OUTL22);};

	private:

		HWSDList * fList;

		char OUTL01[HWSDSPO1_MAX_OUTL01+1];
		char OUTL02[HWSDSPO1_MAX_OUTL02+1];
		char OUTL03[HWSDSPO1_MAX_OUTL03+1];
		char OUTL04[HWSDSPO1_MAX_OUTL04+1];
		char OUTL05[HWSDSPO1_MAX_OUTL05+1];
		char OUTL06[HWSDSPO1_MAX_OUTL06+1];
		char OUTL07[HWSDSPO1_MAX_OUTL07+1];
		char OUTL08[HWSDSPO1_MAX_OUTL08+1];
		char OUTL09[HWSDSPO1_MAX_OUTL09+1];
		char OUTL10[HWSDSPO1_MAX_OUTL10+1];
		char OUTL11[HWSDSPO1_MAX_OUTL11+1];
		char OUTL12[HWSDSPO1_MAX_OUTL12+1];
		char OUTL13[HWSDSPO1_MAX_OUTL13+1];
		char OUTL14[HWSDSPO1_MAX_OUTL14+1];
		char OUTL15[HWSDSPO1_MAX_OUTL15+1];
		char OUTL16[HWSDSPO1_MAX_OUTL16+1];
		char OUTL17[HWSDSPO1_MAX_OUTL17+1];
		char OUTL18[HWSDSPO1_MAX_OUTL18+1];
		char OUTL19[HWSDSPO1_MAX_OUTL19+1];
		char OUTL20[HWSDSPO1_MAX_OUTL20+1];
		char OUTL21[HWSDSPO1_MAX_OUTL21+1];
		char OUTL22[HWSDSPO1_MAX_OUTL22+1];

};


#endif
