/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

/**********************************************************************/
/* Change History:                                                    */
/*                                                                    */
/* 05/06/97  JEH  PTM2467 Clean up error messages for 2.1             */
/*                                                                    */
/* 06/08/98  JEH  PTM2257 Change wording of terminate conv. message.  */
/*                                                                    */
/**********************************************************************/
#ifndef HWSEMSG_H
#define HWSEMSG_H

#include "hwsefmti.h"    // Internal error messages for HWSFMT component.
#include "hwsefmte.h"    // External error messages for HWSFMT component.
#include "hwsecsti.h"    // Internal error messages for HWSConvState class.
#include "hwsecste.h"    // External error messages for HWSConvState class.
#include "hwseclti.h"    // Internal error messages for IMSClient component.
#include "hwseclte.h"    // External error messages for IMSClient component.
                         // Note: hwseclte.h contains #includes for all the
                         //       classes of the IMSClient component:
                         //
                         //       #include "hwsetcpi.h"   Internal TcpOtma
                         //       #include "hwsetcpe.h"   External TcpOtma
                         //       #include "hwseotmi.h"   Internal OTMAMsg
                         //       #include "hwseotme.h"   External OTMAMsg
                         //       #include "hwsecnvi.h"   Internal HWSConverter
                         //       #include "hwsecnve.h"   External HWSConverter

//#include "hwsetcpi.h"
//#include "hwsetcpe.h"
//#include "hwseotmi.h"
//#include "hwseotme.h"
//#include "hwsecnvi.h"
//#include "hwsecnve.h"

#define HWS_OK       0000

/*--------------------------------------------------------------------*/
/* Error message ranges are                                           */
/*                                                                    */
/* -> External error messages:   0001 -  8999                         */
/* -> Internal error messages:   9000 -  9999                         */
/* -> Server command processor: 10000 - 11000                         */
/*                                                                    */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Defines for internal error messages (9000 - 9999)                  */
/*--------------------------------------------------------------------*/
#define HWS_IERR  	9000
#define HWS_IERROR	9999
#define HWS_IERROR_S "An internal error has occured."
// Explanation:  An internal error in IMS Web prevented the request
//               from completing successfully.
// User Action:  Record the information in Diagnostic Information and
//               contact your IBM service representative.

/*--------------------------------------------------------------------*/
/* Defines for server command processor error messages (10000 - 11000)*/
/*--------------------------------------------------------------------*/
#define HWS_CERROR	11000

/* 12-15-97 Added by T. Lai                                           */
/* Redefined the error codes & messages for HWSCMD component          */
/*--------------------------------------------------------------------*/
/* HWSCMD Component External Error Definition                         */
/* 10000 - 10500                                                      */
/*                                                                    */
/* External General Error codes for HWSCMD commands                   */
/* 10000 - 10200                                                      */
/*                                                                    */
/* External Error codes for HWSCMD TRACE command                      */
/* 10201 - 10300                                                      */
/*                                                                    */
/* External Error codes for HWSCMD DISPLAY command                    */
/* 10301 - 10400                                                      */
/*                                                                    */
/* External Error codes for HWSCMD EXIT command                       */
/* 10401 - 10500                                                      */
/*--------------------------------------------------------------------*/

/* HWSCMD command general external error codes                        */
#define HWSCMD_EXT_ERROR	        10000
#define HWSCMD_EXT_ERROR_END	     10200

/* HWSTRACE Command external error codes                              */
#define HWS_TRACE_EXT_ERROR	     10201
#define HWS_TRACE_EXT_ERROR_END	  10300

/* HWSDISPLAY Command external error codes                            */
#define HWS_DISPLAY_EXT_ERROR	     10301
#define HWS_DISPLAY_EXT_ERROR_END  10400

/* HWSEXIT Command external error codes                               */
#define HWS_EXIT_EXT_ERROR	        10401
#define HWS_EXIT_EXT_ERROR_END	  10500

/*--------------------------------------------------------------------*/
/* HWSCMD Component Internal Error Definition                         */
/* 10501 - 11000                                                      */
/*                                                                    */
/* Internal General Error codes for HWSCMD commands                   */
/* 10501 - 10700                                                      */
/*                                                                    */
/* Internal Error codes for HWSCMD TRACE command                      */
/* 10701 - 10800                                                      */
/*                                                                    */
/* Internal Error codes for HWSCMD DISPLAY command                    */
/* 10801 - 10900                                                      */
/*                                                                    */
/* Internal Error codes for HWSCMD EXIT command                       */
/* 10901 - 11000                                                      */
/*--------------------------------------------------------------------*/

/* HWSCMD command general internal error codes                        */
#define HWSCMD_INT_ERROR	        10501
#define HWSCMD_INT_ERROR_END	     10700

/* HWSTRACE Command internal error codes                              */
#define HWS_TRACE_INT_ERROR	     10701
#define HWS_TRACE_INT_ERROR_END	  10800

/* HWSDISPLAY Command internal error codes                            */
#define HWS_DISPLAY_INT_ERROR	     10801
#define HWS_DISPLAY_INT_ERROR_END  10900

/* HWSEXIT Command internal error codes                               */
#define HWS_EXIT_INT_ERROR	        10901
#define HWS_EXIT_INT_ERROR_END	  11000


/*--------------------------------------------------------------------*/
/* Defines for internal and external error messages by component and  */
/* class.                                                             */
/*                                                                    */
/*--------------------------------------------------------------------*/
/* HWSTRAN component:                                                 */
/*--------------------------------------------------------------------*/
#define HWS_TRN_ERROR      1000  /* See classes below when selecting  */
#define HWS_TRN_ERROR_END  1099  /* a new error message.   PTM2322    */
#define HWS_TRN_IERROR     9000
#define HWS_TRN_IERROR_END 9099

/* HWSTran Class of HWSTran component                                 */
#define HWS_TRA_ERROR	   1000
#define HWS_TRA_ERROR_END  1079
#define HWS_TRA_IERROR	   9000
#define HWS_TRA_IERROR_END 9079
/* HWSConvState Class of HWSTran component                            */
#define HWS_CST_ERROR	   1080
#define HWS_CST_ERROR_END  1099
#define HWS_CST_IERROR	   9080
#define HWS_CST_IERROR_END 9099

/*--------------------------------------------------------------------*/
/* HWSFMT (HWSMFSFormat) component:                                   */
/*--------------------------------------------------------------------*/
#define HWS_MFSF_ERROR	   1100	/* See classes below when selecting  */
#define HWS_MFSF_ERROR_END 1199  /* a new error message.              */

/* HWSMFSFormat Class                                                 */
#define HWS_MFS_ERROR	   1100	
#define HWS_MFS_ERROR_END  1119
#define HWS_MFS_IERROR	   9100
#define HWS_MFS_IERROR_END 9119
/* HWSMsgFormat Class                                                 */
#define HWS_MSG_ERROR	   1120
#define HWS_MSG_ERROR_END  1139
#define HWS_MSG_IERROR	   9120
#define HWS_MSG_IERROR_END 9139
/* HWSLPageFormat Class                                               */
#define HWS_LPG_ERROR	   1140
#define HWS_LPG_ERROR_END  1159
#define HWS_LPG_IERROR	   9140
#define HWS_LPG_IERROR_END 9159
/* HWSSegFormat Class                                                 */
#define HWS_SEG_ERROR	   1160
#define HWS_SEG_ERROR_END  1179
#define HWS_SEG_IERROR	   9160
#define HWS_SEG_IERROR_END 9169
/* HWSFldFormat Class                                                 */
#define HWS_FLD_ERROR	   1180
#define HWS_FLD_ERROR_END  1199
#define HWS_FLD_IERROR	   9180
#define HWS_FLD_IERROR_END 9199

/*--------------------------------------------------------------------*/
/* IMSClient component:                                               */
/*--------------------------------------------------------------------*/
#define HWS_CLT_ERROR      2000  /* See classes below when selecting  */
#define HWS_CLT_ERROR_END  2999  /* a new error message.              */
#define HWS_CLT_IERROR     9500
#define HWS_CLT_IERROR_END 9999
/* Conversion Component                                               */
#define HWS_CNV_ERROR	   2500
#define HWS_CNV_ERROR_END  2549
#define HWS_CNV_IERROR	   9500
#define HWS_CNV_IERROR_END 9549
/* TcpOtma Component                                                  */
#define HWS_TCP_ERROR	   2700
#define HWS_TCP_ERROR_END  2799
#define HWS_TCP_IERROR	   9700
#define HWS_TCP_IERROR_END 9799
/* OtmaMsg Component                                                  */
#define HWS_OTM_ERROR	   2600
#define HWS_OTM_ERROR_END  2649
#define HWS_OTM_IERROR	   9600
#define HWS_OTM_IERROR_END 9649

/*--------------------------------------------------------------------*/
/* The internal error messages for the HWSTran class are included     */
/* in this file:                                                      */
/*--------------------------------------------------------------------*/
#define HWSTRN_CONVID_NOTFOUND      9000
#define HWSTRN_CONVID_NOTFOUND_S    "HWSTran::doIMS>Unable to locate hidden field convID."
#define HWSTRN_RUNAME_NOTFOUND      9001
#define HWSTRN_RUNAME_NOTFOUND_S    "HWSTran::doIMS>Unable to locate hidden field RUName."
#define HWSTRN_DATETIME_NOTFOUND    9002
#define HWSTRN_DATETIME_NOTFOUND_S  "HWSTran::doIMS>Unable to locate hidden field dateTime."
#define HWSTRN_MILLISECS_NOTFOUND   9003
#define HWSTRN_MILLISECS_NOTFOUND_S "HWSTran::doIMS>Unable to locate hidden field millisecs."
#define HWSTRN_INLPGNAME_NOTFOUND   9004
#define HWSTRN_INLPGNAME_NOTFOUND_S "HWSTran::doIMS>Unable to locate hidden field inLPageName."
#define HWSTRN_HWSTERM_NOTFOUND     9005
#define HWSTRN_HWSTERM_NOTFOUND_S   "HWSTran::doIMS>Unable to locate hidden field HWSTerm."
#define HWSTRN_BAD_DATFILENAME      9006
#define HWSTRN_BAD_DATFILENAME_S    "HWSTran::doIMS>getConvIDString returned NULL filename pointer."

/*--------------------------------------------------------------------*/
/* The external error messages for the HWSTran class are included     */
/* in this file:                                                      */
/*--------------------------------------------------------------------*/

#define HWSTRN_HWSPATH_NOTFOUND  1000
#define HWSTRN_HWSPATH_NOTFOUND_S "System information HWSPATH missing or invalid."
// Explanation:  IMS Web was unable to find the HWSPATH system information.
// User Action:  This is most likely an installation error.
//               For OS/2, verify that the HWSPATH environment variable is set
//               to the path where IMS Web Runtime is installed.
//               For Windows NT, use REGEDIT to verify that the value of HWSPATH in the registry
//               is set to the path where IMS Web Runtime is installed.  For AIX and OS/390, IMS Web Runtime
//               is installed in /usr/lpp/imsweb.

#define HWSTRN_NOSEG             1001
#define HWSTRN_NOSEG_S           "No segments in the input."
// Explanation:  A transaction input message could not be produced from the request.
// User Action:  In order to execute an IMS transaction or command, the input message
//               must contain at least the transaction code or command.  If the transaction
//               code is not provided by the MID, verify that you have entered at least the
//               transaction code or command in the input HTML before selecting SUBMIT.

#define HWSTRN_NOAPPLDATA        1002
#define HWSTRN_NOAPPLDATA_S      "No data returned from host application."
// Explanation:  The host application did not generate any output message
//               for this request.
// User Action:  This is most likely a host application error.
//               Contact your IMS support group and report the problem.

#define HWSTRN_HIDDENFLD_NOTFOUND 1003
#define HWSTRN_HIDDENFLD_NOTFOUND_S       "Hidden Fields in HTML not found."
// Explanation:  IMS Web was unable to find the state information for an IMS Web conversation in the
//               input HTML.
// User Action:  Verify that you did not inadvertently remove the hidden fields while
//               modifying the input HTML associated with a conversational transaction.
//               If all hidden fields are present, contact your IBM service representative.

#define HWSTRN_NO_STORAGE         1004
#define HWSTRN_NO_STORAGE_S       "Insufficient storage."
// Explanation:  IMS Web was unable to obtain virtual storage.
// User Action:  Reduce your system's demands for virtual storage.

#define HWSTRN_CONV_SYNC_ERR      1005
#define HWSTRN_CONV_SYNC_ERR_S    "IMS Web's conversational protocol has been violated."
// Explanation:  IMS Web detected inconsistent, missing, or invalid information for an IMS Web conversational
//               transaction.  IMS Web attempted to terminate the conversation.
// User Action:  A number of situations can contribute to this error.  For example:
//               submitting data for the conversation from a browser page that is not in the
//               normal sequence for the conversation.  This is usually due to selection of a
//               browser page using the BACK function.  Protocol violations can also occur when the
//               command HWSCMD EXIT CONV is used to end a conversation while it is in progress, or
//               due to corruption of the DAT file associated with the conversation.

#define HWSTRN_NO_NEXTINLPG       1007
#define HWSTRN_NO_NEXTINLPG_S     "Next input lpage missing."
// Explanation:  IMS Web was unable to find the logical page to use for the input of the next
//               iteration of the IMS Web conversational transaction.
// User Action:  Verify that the MIDs and MODs you provided to the IMS Web Studio Tool are
//               valid for a conversational transaction.

#define HWSTRN_TERMINATE          1008
#define HWSTRN_TERMINATE_S        "Request to terminate IMS Web conversation sent."
// Explanation:  IMS Web sent a message to IMS/OTMA, in response to selection of the TERMINATE button,
//               requesting termination of the host end of an IMS Web conversation.  The host end of
//               the conversation may or may not be terminated.
// User Action:  Verify that the IMS Web conversation was terminated by entering HWSCMD DISPLAY
//               CONV on the Web server and /DISPLAY CONV on the host.  If IMS Web was unable to
//               terminate the conversation, there may be additional information in the Diagonstic
//               Information field of the output HTML for the message.
//

#define HWSTRN_BAD_TERMINATE      1009
#define HWSTRN_BAD_TERMINATE_S    "IMS Web conversation already terminated."
// Explanation:  You attempted to terminate an IMS Web conversation by selecting the TERMINATE
//               button.  The IMS Web conversation was already terminated.
// User Action:  Do not use the TERMINATE button for a conversation which has already been terminated.
//               The TERMINATE button should only be selected for an active IMS Web conversation.

#define HWSTRN_DFSMSG             1010                     /* PTM2322 */
// Explanation:  IMS Web received unexpected output from IMS while processing a conversational transaction.
//               One of the MFS default MODs was used to format the output.
// User Action:  Most likely this is an IMS message.  Check the IMS Messages and Codes documentation
//               for additional information.

#define HWSTRN_TERMINATE_FAIL     1011
#define HWSTRN_TERMINATE_FAIL_S   "Attempt to terminate IMS Web conversation failed."
// Explanation:  The attempt by IMS Web to send a message to IMS/OTMA requesting termination of the host end of an IMS Web
//               conversation failed.  The IMS Web conversation was not terminated.
// User Action:  Check the Diagnostic Information field of the output HTML for the message for information
//               about the reason for the failure.  Once you have fixed the problem, use the HWSCMD EXIT CONV
//               command to terminate the conversation.

#endif
