/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/
#ifndef HWSSEGF_HPP
#define HWSSEGF_HPP

//  The HWSSegFormat class inherits from the HWSSegDesc class to inherit
//  all the information about the segment.
//  HWSSegFormat enhances the parent class by providing methods
//  to format the segments.
//
//  HWSSegFormat needs to know how to handle option 1,2,3 formatting.
//  HWSSegFormat needs to know how to find the location of a field in a
//  buffer, as well as understanding which fields are omitted, etc.
#include "hwsseg.hpp"

class HWSLNode;
class HWSDList;
class HWSConverter;
class HWSError;

class DllExport HWSSegFormat : public HWSSegDesc {

  // Public access
  public:

     // Member functions
     HWSSegFormat(char *sName);
     ~HWSSegFormat();                 // Destructor.

     // Error code range:          1300-1399
     // Internal error code range: 9300-9399

     // This method will parse the segment buffer to find the value for
     // the field specified by the field name.
     char *getPtrInSegBuf( HWSError   *errStruc,
                           char       *fldName,
                           int        pp,
                           HWSLNode   *segment );

     HWSLNode *formatIn( HWSError *errStruc, HWSDList *fldList, HWSConverter *convObj );
     HWSDList  *formatOut( HWSError *errStruc, HWSDList *segList, HWSConverter *convObj );

};

#endif
