/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/
/*--------------------------------------------------------------------*/
/*                                                                    */
/* Change History:                                                    */
/*                                                                    */
/* 08\18\97  JEH   R210 Conversational processing                     */
/*                                                                    */
/*                 - added attributes for hidden HTML fields.         */
/*                                                                    */
/* 06/16/98  JEH   PTM2632 Make VRM accessible to generated code.     */
/*--------------------------------------------------------------------*/

#ifndef HWSTRANI_HPP
#define HWSTRANI_HPP

#define  MAX_USER_NAME 8
#define  MAX_GROUP_NAME 8
#define  MAX_PASSWORD 8

#include "hws.h"

class HWSTranOut;
class HWSMFSFormat;
class HWSDList;

//  HWSTranIn is a base class.
//  The transaction input class generated by the tool will inherit
//  from this class.
class DllExport HWSTranIn {

   // Public access
   public:

      // Member functions
      HWSTranIn(char * cgiName);    // Constructor.
      ~HWSTranIn();                  // Destructor.

      void setUser(char * userName);
      void setGroup(char * groupName);
      void setHost(char * hostName);
      void setPort(char * hostPort);
      void setIMS(char * imsName);
      void setRUname(char * RUname);

      // <!-- BEGIN CHANGES FOR R210 -->
      void setInLPageName( char *inLPN );
      void setConvIDFN( char *cIDFN );
      void setDateTime( char *dT );
      void setMillisecs( char *mS );
      void setPassword( char *passwd );
      void setHwsTerm( char *term );
      // <!-- END CHANGES FOR R210 -->

      inline char * getUser() { return userName; };
      inline char * getGroup() { return groupName; };
      inline char * getHost() { return hostName; };
      inline char * getPort() { return hostPort; };
      inline char * getIMS() { return imsName; };
      inline char * getRUname() { return RUname; };
      inline char * getCGIName() { return cgiName; };

      // <!-- BEGIN CHANGES FOR R210 -->
      inline char * getInLPageName() { return inLPageName; };
      inline char * getConvIDFN() { return convIDFN; };
      inline char * getDateTime() { return dateTime; };
      inline char * getMillisecs() { return millisecs; };
      inline char * getPassword() { return password; };
      inline char * getHwsTerm() { return hwsTerm; };
      // <!-- END CHANGES FOR R210 -->

      // implementation dependant
      virtual HWSTranOut * execute();
      virtual HWSDList *   export();

      // Data members
      HWSMFSFormat * formatObj;
      CONVType       language;
      char * cgiName;
      char * userName;
      char * groupName;
      char * hostName;
      char * hostPort;
      char * imsName;
      char * RUname;

      // <!-- BEGIN CHANGES FOR R210 -->
      // The following fields, along with RUname, are the hidden HTML
      // fields used in conversational processing.
      char      *inLPageName;
      char      *convIDFN;
      char      *dateTime;
      char      *millisecs;
      char      *hwsTerm;

      char      *password;

      HWSDList  *attrs;
      void      setAttr(char * name, char * value);
      char *    getAttr(char * name);

      HWSVers         HWSVRM;                              /* PTM2632 */
      inline HWSVers  getHWSVRM() { return HWSVRM; };      /* PTM2632 */
      // <!-- END CHANGES FOR R210 -->

};

#endif


