/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

/**********************************************************************/
/*                                                                    */
/* Change History:                                                    */
/*                                                                    */
/* 04/01/98  JEH  PTM2348  Add strupr using toupper for AIX           */
/*                                                                    */
/* 05/29/98  JEH  PTM2546 hwsdata to /var/tmp/imsweb for AIX.         */
/*                                                                    */
/* 06/18/98  ckt  def#2645  OS/390 code page conversion               */
/*                                                                    */
/**********************************************************************/
#ifndef HWSUTIL_HPP
#define HWSUTIL_HPP

#include "hws.h"
#include <time.h>
#include <sys/timeb.h>
#include <ctype.h>        // PTM2348

typedef enum  {
   DATE1, /*   YY.DDD     */
   DATE2, /*   MM/DD/YY   */
   DATE3, /*   DD/MM/YY   */
   DATE4  /*   YY/MM/DD   */
} DateType;

typedef enum  {
   TIME1  /*   HH:MM:SS   */
} TimeType;

struct HWStimeb {
	long           time;
	unsigned short millitm;
   short          timezone;
  	short          dstflag;
};

//  The UTIL class is a container for all utility functions
class DllExport HWSUtil {

   // Public access
   public:

      // Member functions
      HWSUtil();
      ~HWSUtil();              // Destructor.

      void unper(char * buf, CONVType lang);               //def #2645
      char * itoa(int n, char s[], short base);
      char * getRUName();
      char * getRUname(char *ruName);

      char *getTime(TimeType tType);
      char *getDate(DateType dType);

      char *getConvIDString( void *cID );

      void HWSftime( struct HWStimeb *timeptr );

      char *strupr( char *inString );                   // PTM2348
#if defined HWSAIX || defined HWS390
      int  makeDirIfNotThere( char *lastDirName );      // PTM2546
#endif

   private:
      unsigned long cksum( unsigned short *buf, int nbytes );
      char htoc(char * h);
#if defined HWS390
      char os390_conv(char *h, CONVType lang);                     //Def #2645
#endif
};

#endif
