<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/XSL/Transform/1.0"
                xmlns="http://www.w3.org/TR/REC-html40"
                result-ns="">

<xsl:template match="XMI">
  <xsl:apply-templates select="XMI.content/EOM"/>
</xsl:template>

<!--==================================================================-->
<!--  EOM                                                             -->
<!--==================================================================-->
<xsl:template match="EOM">
  <HTML>
    <HEAD>
      <TITLE> Model: <xsl:value-of select="@xmi.label"/> </TITLE>
    </HEAD>
    <BODY>
      <FONT SIZE="6"> <B> Model: <xsl:value-of select="@xmi.label"/> </B> </FONT> <BR/>
      <FONT SIZE="3"> <xsl:value-of select="../../@timestamp"/> </FONT> <BR/> <BR/>

      <xsl:apply-templates select="EOMContents.repository/Repository/Repository.allFiles/GeneratedFile[File.fileType/@xmi.value='IDL']">
        <xsl:sort select="@xmi.label"/>
      </xsl:apply-templates>

      <xsl:apply-templates select="EOMContents.repository/Repository/Repository.idlNamespace/Module">
        <xsl:sort select="@xmi.label"/>
      </xsl:apply-templates>

      <xsl:apply-templates select="EOMContents.repository/Repository/Repository.idlNamespace/BOInterface|
                                   EOMContents.repository/Repository/Repository.idlNamespace/Module/Module.nested/BOInterface">
        <xsl:sort select="@xmi.label"/>
      </xsl:apply-templates>

      <xsl:apply-templates select="EOMContents.repository/Repository/Repository.idlNamespace/DOInterface|
                                   EOMContents.repository/Repository/Repository.idlNamespace/Module/Module.nested/DOInterface">
        <xsl:sort select="@xmi.label"/>
      </xsl:apply-templates>

    </BODY>
  </HTML>
</xsl:template>


<!--==================================================================-->
<!-- Repository.allFiles/GeneratedFile                                -->
<!--==================================================================-->
<xsl:template match="Repository.allFiles/GeneratedFile">
  <A NAME="{@xmi.id}"><!-- --></A>

  <TABLE BORDER="1" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
    <TR>
      <TD BGCOLOR="6FB6E2" COLSPAN="1">
        <FONT SIZE="3"> <B> <I> File: </I> </B> </FONT> <BR/>
        <FONT SIZE="5"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT>
        <BR/>
        <FONT SIZE="-1">
          <!-- Menu -->
          <xsl:choose>
            <xsl:when test="GeneratedFile.sourceSegment/DeclaratorSource"> <A HREF="#{@xmi.id}:constructs">Constructs</A> | </xsl:when>
            <xsl:otherwise>Constructs | </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="GeneratedFile.sourceSegment/ModuleSource"> <A HREF="#{@xmi.id}:modules">Modules</A> </xsl:when>
            <xsl:otherwise>Modules</xsl:otherwise>
          </xsl:choose>

          <xsl:if test="GeneratedFile.sourceSegment/InterfaceSource/InterfaceSource.interface[BOInterface]">
            | <A HREF="#{@xmi.id}:BOs">BO Interfaces</A>
          </xsl:if>

          <xsl:if test="GeneratedFile.sourceSegment/InterfaceSource/InterfaceSource.interface[DOInterface]">
            | <A HREF="#{@xmi.id}:DOs">DO Interfaces</A>
          </xsl:if>

        </FONT>
      </TD>
    </TR>
  </TABLE>

  <KBD> <xsl:value-of select="GeneratedFile.comments"/> </KBD>
  <P/>
  <B> File Type: </B> <xsl:value-of select="File.fileType/@xmi.value"/>

  <!-- Only BO's interface has include files -->
  <xsl:if test='GeneratedFile.sourceSegment/InterfaceSource/InterfaceSource.interface[BOInterface]'>
    <DL>
      <B> Include: </B>

      <xsl:for-each select="GeneratedFile.include/FileReference/FileReference.file/File">
        <!-- This way the Framework objects are listed first -->
        <xsl:sort select="@xmi.uuid"/>
        <xsl:sort select="@xmi.label"/>

        <!-- For Framework objects -->
        <DD> OBFrame:::<xsl:value-of select="substring-before(substring-after(@xmi.uuid,':::'),'::')"/>::<xsl:value-of select="@xmi.label"/> </DD>

      </xsl:for-each>

      <xsl:for-each select="GeneratedFile.include/FileReference/FileReference.file/GeneratedFile">
        <xsl:sort select="id(@xmi.idref)/@xmi.label|@xmi.label"/>

        <!-- For local objects -->
        <xsl:if test="@xmi.idref"> <DD> <A HREF="#{@xmi.idref}"> <xsl:value-of select="id(@xmi.idref)/@xmi.label"/> </A> </DD> </xsl:if>

        <!-- For remote objects -->
        <xsl:if test="@xml:link"> <DD> <FONT COLOR="RED"> <xsl:value-of select="@xmi.label"/> </FONT> </DD> </xsl:if>

      </xsl:for-each>

    </DL>
  </xsl:if>

  <DL>
    <B> Platform: </B>
    <xsl:for-each select="GeneratedFile.platform/*">
     <DD> <xsl:value-of select="local-part(.)"/> </DD>
    </xsl:for-each>
  </DL>

  <!--=================== CONSTRUCT SUMMARY ===================-->
  <xsl:if test="GeneratedFile.sourceSegment/DeclaratorSource">
    <A NAME="{@xmi.id}:constructs"><!-- --></A>

    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR BGCOLOR="87CEFA">
        <TD COLSPAN="2">
          <FONT SIZE="4"> <B> Constructs Summary </B> </FONT> </TD>
      </TR>

      <xsl:for-each select="id(GeneratedFile.sourceSegment/DeclaratorSource/DeclaratorSource.declarator/Constant/@xmi.idref)">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Constant-Summary"/>
      </xsl:for-each>

      <xsl:for-each select="id(GeneratedFile.sourceSegment/DeclaratorSource/DeclaratorSource.declarator/Typedef/@xmi.idref)">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Typedef-Summary"/>
      </xsl:for-each>

      <xsl:for-each select="id(GeneratedFile.sourceSegment/DeclaratorSource/DeclaratorSource.declarator/Union/@xmi.idref)">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Union-Summary"/>
      </xsl:for-each>

      <xsl:for-each select="id(GeneratedFile.sourceSegment/DeclaratorSource/DeclaratorSource.declarator/Enumeration/@xmi.idref)">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Enumeration-Summary"/>
      </xsl:for-each>

      <xsl:for-each select="id(GeneratedFile.sourceSegment/DeclaratorSource/DeclaratorSource.declarator/Struct/@xmi.idref)">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Struct-Summary"/>
      </xsl:for-each>

      <xsl:for-each select="id(GeneratedFile.sourceSegment/DeclaratorSource/DeclaratorSource.declarator/Exception/@xmi.idref)">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Exception-Summary"/>
      </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>

  <!--==================== MODULE SUMMARY ====================-->
  <xsl:if test="GeneratedFile.sourceSegment/ModuleSource">
    <A NAME="{@xmi.id}:modules"><!-- --></A>
    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR BGCOLOR="87CEFA">
        <TD COLSPAN="1">
          <FONT SIZE="4"> <B> Modules Summary</B> </FONT> </TD>
      </TR>

      <xsl:for-each select="GeneratedFile.sourceSegment/ModuleSource">
        <TR> <TD>
          <xsl:sort select="id(ModuleSource.module/Module/@xmi.idref)/@xmi.label"/>
          <A href="#{ModuleSource.module/Module/@xmi.idref}"> <xsl:value-of select='id(ModuleSource.module/Module/@xmi.idref)/@xmi.label'/> </A>
        </TD> </TR>
      </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>

  <!--================= BO INTERFACE SUMMARY =================-->
  <xsl:if test="GeneratedFile.sourceSegment/ModuleSource/SourceSegment.nested/InterfaceSource/InterfaceSource.interface[BOInterface]">
    <A NAME="{@xmi.id}:BOs"><!-- --></A>
    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR BGCOLOR="87CEFA">
        <TD COLSPAN="1">
          <FONT SIZE="4"> <B> BO Interfaces Summary</B> </FONT> </TD>
      </TR>

      <xsl:for-each select="GeneratedFile.sourceSegment/ModuleSource/SourceSegment.nested/InterfaceSource/InterfaceSource.interface/BOInterface">
        <xsl:sort select="id(@xmi.idref)/@xmi.label"/>
        <TR> <TD>
          <A href="#{@xmi.idref}"> <xsl:value-of select='id(@xmi.idref)/@xmi.label'/> </A>
        </TD> </TR>
      </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>

  <!--================= DO INTERFACE SUMMARY =================-->
  <xsl:if test="GeneratedFile.sourceSegment/ModuleSource/SourceSegment.nested/InterfaceSource/InterfaceSource.interface[DOInterface]">
    <A NAME="{@xmi.id}:DOs"><!-- --></A>
    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR BGCOLOR="87CEFA">
        <TD COLSPAN="1">
          <FONT SIZE="4"> <B> DO Interfaces Summary</B> </FONT> </TD>
      </TR>

      <xsl:for-each select="GeneratedFile.sourceSegment/ModuleSource/SourceSegment.nested/InterfaceSource/InterfaceSource.interface/DOInterface">
        <xsl:sort select="id(@xmi.idref)/@xmi.label"/>
        <TR> <TD>
          <A href="#{@xmi.idref}"> <xsl:value-of select='id(@xmi.idref)/@xmi.label'/> </A>
        </TD> </TR>
      </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>

  <!--=================== CONSTRUCT DETAILS ===================-->
  <xsl:if test="GeneratedFile.sourceSegment/DeclaratorSource">
    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR>
        <TD BGCOLOR="87CEFA" COLSPAN="1">
          <FONT SIZE="4"> <B> Construct Details </B> </FONT>
        </TD>
      </TR>

      <xsl:for-each select="id(GeneratedFile.sourceSegment/DeclaratorSource/DeclaratorSource.declarator/Constant/@xmi.idref)">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Constant-Details"/>
      </xsl:for-each>

      <xsl:for-each select="id(GeneratedFile.sourceSegment/DeclaratorSource/DeclaratorSource.declarator/Typedef/@xmi.idref)">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Typedef-Details"/>
      </xsl:for-each>

      <xsl:for-each select="id(GeneratedFile.sourceSegment/DeclaratorSource/DeclaratorSource.declarator/Union/@xmi.idref)">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Union-Details"/>
      </xsl:for-each>

      <xsl:for-each select="id(GeneratedFile.sourceSegment/DeclaratorSource/DeclaratorSource.declarator/Enumeration/@xmi.idref)">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Enumeration-Details"/>
      </xsl:for-each>

      <xsl:for-each select="id(GeneratedFile.sourceSegment/DeclaratorSource/DeclaratorSource.declarator/Struct/@xmi.idref)">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Struct-Details"/>
      </xsl:for-each>

      <xsl:for-each select="id(GeneratedFile.sourceSegment/DeclaratorSource/DeclaratorSource.declarator/Exception/@xmi.idref)">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Exception-Details"/>
      </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>


</xsl:template>


<!--==================================================================-->
<!--  Modules                                                         -->
<!--==================================================================-->
<xsl:template match="Module">

  <A NAME="{@xmi.id}"><!-- --></A>
  <TABLE BORDER="1" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
    <TR>
      <TD BGCOLOR="6FB6E2" COLSPAN="1">
        <FONT SIZE="3"> <B> <I>Module: </I> </B> <BR/> </FONT>
        <FONT SIZE="5"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT>
        <BR/>
        <FONT SIZE="-1">
          <!-- Menu -->
          <xsl:choose>
            <xsl:when test="Scope.declarator"> <A HREF="#{@xmi.id}:constructs">Constructs</A> </xsl:when>
            <xsl:otherwise>Constructs </xsl:otherwise>
          </xsl:choose>

          <xsl:if test="Module.nested[BOInterface]">
            | <A HREF="#{@xmi.id}:BOs">BO Interfaces</A>
          </xsl:if>

          <xsl:if test="Module.nested[DOInterface]">
            | <A HREF="#{@xmi.id}:DOs">DO Interfaces</A>
          </xsl:if>

        </FONT>
      </TD>
    </TR>
  </TABLE>

  <KBD> <xsl:value-of select="id(Module.sourceCode/ModuleSource/@xmi.idref)/ModuleSource.comments"/> </KBD> <BR/> <BR/>

  <!--=================== CONSTRUCT SUMMARY ===================-->
  <xsl:if test="Scope.declarator">
    <A NAME="{@xmi.id}:constructs"><!-- --></A>

    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR BGCOLOR="87CEFA">
        <TD COLSPAN="2">
          <FONT SIZE="4"> <B> Constructs Summary </B> </FONT> </TD>
      </TR>

      <xsl:for-each select="Scope.declarator">
        <xsl:call-template name="Constructs-Summary"/>
      </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>

  <!--================= BO INTERFACE SUMMARY =================-->
  <xsl:if test="Module.nested[BOInterface]">
    <A NAME="{@xmi.id}:BOs"><!-- --></A>
    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR BGCOLOR="87CEFA">
        <TD COLSPAN="1">
          <FONT SIZE="4"> <B> BO Interfaces Summary</B> </FONT> </TD>
      </TR>

      <xsl:for-each select="Module.nested/BOInterface">
        <xsl:sort select="@xmi.label"/>
        <TR> <TD>
          <A href="#{@xmi.id}"> <xsl:value-of select="@xmi.label"/> </A>
        </TD> </TR>
      </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>

  <!--================= DO INTERFACE SUMMARY =================-->
  <xsl:if test="Module.nested[DOInterface]">
    <A NAME="{@xmi.id}:DOs"><!-- --></A>
    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR BGCOLOR="87CEFA">
        <TD COLSPAN="1">
          <FONT SIZE="4"> <B> DO Interfaces Summary</B> </FONT> </TD>
      </TR>

      <xsl:for-each select="Module.nested/DOInterface">
        <xsl:sort select="@xmi.label"/>
        <TR> <TD>
          <A href="#{@xmi.id}"> <xsl:value-of select="@xmi.label"/> </A>
        </TD> </TR>
      </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>

  <!--=================== CONSTRUCT DETAILS ===================-->
  <xsl:if test="Scope.declarator">
    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR>
        <TD BGCOLOR="87CEFA" COLSPAN="1">
          <FONT SIZE="4"> <B> Construct Details </B> </FONT>
        </TD>
      </TR>

      <xsl:for-each select="Scope.declarator">
        <xsl:call-template name="Constructs-Details"/>
      </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>

</xsl:template>


<!--==================================================================-->
<!--  Repository.idlNamespace/BOInterface                             -->
<!--==================================================================-->
<xsl:template match="BOInterface">
  <A NAME="{@xmi.id}"><!-- --></A>
  <TABLE BORDER="1" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
    <TR>
      <TD BGCOLOR="6FB6E2" COLSPAN="1">
        <FONT SIZE="3"> <B> <I>BO Interface: </I> </B> <BR/> </FONT>
        <xsl:if test="from-ancestors(Module)"> <FONT SIZE="5"> <B> <xsl:value-of select="from-ancestors(Module)/@xmi.label"/>::</B> </FONT> </xsl:if>
        <FONT SIZE="5"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT> <BR/>
        <FONT SIZE="-1">
          <!-- Menu -->
          <xsl:choose>
            <xsl:when test="Scope.declarator"> <A HREF="#{@xmi.id}:constructs">Constructs</A> | </xsl:when>
            <xsl:otherwise>Constructs | </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="Interface.attribute"> <A HREF="#{@xmi.id}:attributes">Attributes</A> | </xsl:when>
            <xsl:otherwise>Attributes | </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="Interface.operation"> <A HREF="#{@xmi.id}:methods">Methods</A> | </xsl:when>
            <xsl:otherwise>Methods | </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="Interface.associationEnd"> <A HREF="#{@xmi.id}:rels">Relationships</A> </xsl:when>
            <xsl:otherwise>Relationships</xsl:otherwise>
          </xsl:choose>

        </FONT>
      </TD>
    </TR>
  </TABLE>

  <KBD> <xsl:value-of select="Scope.comments"/> </KBD>

  <P/> <B> Queryable: </B> <xsl:value-of select="BOInterface.isQueryable/@xmi.value"/>
  <DL>
    <B> Inherits from: </B>

    <xsl:for-each select="Interface.parent/BOInterface[@xml:link]">
      <!-- This way the Framework objects are listed first -->
      <xsl:sort select="@xmi.uuid"/>
      <xsl:sort select="@xmi.label"/>

      <!-- For Framework objects -->
      <xsl:if test="contains(@xmi.uuid,'LOCAL:IVB:OBFrame:::')">
        <DD> OBFrame:::<xsl:value-of select="substring-before(substring-after(@xmi.uuid,':::'),'::')"/>::<xsl:value-of select="@xmi.label"/> </DD>
      </xsl:if>

    </xsl:for-each>

    <xsl:for-each select="Interface.parent/BOInterface">
      <xsl:sort select="id(@xmi.idref)/@xmi.label|@xmi.label"/>

      <xsl:choose>
        <xsl:when test='@xml:link'>
           <!-- For remote user-defined BO Interfaces -->
           <xsl:if test="not(contains(@xmi.uuid,'LOCAL:IVB:OBFrame:::'))">
             <DD> <FONT COLOR="RED"> <xsl:value-of select="@xmi.label"/> </FONT> </DD>
           </xsl:if>
        </xsl:when>

        <xsl:otherwise>
          <!-- For local user-defined BO Interfaces -->
          <DD> <A href="#{@xmi.idref}"> <xsl:value-of select='id(@xmi.idref)/@xmi.label'/> </A> </DD>
        </xsl:otherwise>
      </xsl:choose>

    </xsl:for-each>

  </DL>

  <!--=================== CONSTRUCT SUMMARY ===================-->
  <xsl:if test="Scope.declarator">
    <A NAME="{@xmi.id}:constructs"><!-- --></A>

    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR BGCOLOR="87CEFA">
        <TD COLSPAN="2">
          <FONT SIZE="4"> <B> Constructs Summary </B> </FONT> </TD>
      </TR>

      <xsl:for-each select="Scope.declarator">
        <xsl:call-template name="Constructs-Summary"/>
      </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>

  <!--================== ATTRIBUTE SUMMARY ====================-->
  <xsl:if test="Interface.attribute">
    <A NAME="{@xmi.id}:attributes"><!-- --></A>
    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR BGCOLOR="87CEFA">
        <TD COLSPAN="2">
          <FONT SIZE="4"> <B> Attribute Summary </B> </FONT> </TD>
      </TR>

      <xsl:for-each select="Interface.attribute/Attribute">
        <xsl:sort select="@xmi.label"/>
        <TR BGCOLOR="#FFFFFF">
          <TD ALIGN="RIGHT" WIDTH="1%" NOWRAP="TRUE">
            <FONT SIZE="-1"> <CODE>
              <xsl:apply-templates select="Attribute.type"/>
            </CODE> </FONT>
          </TD>
          <TD> <CODE> <B> <A HREF="#{@xmi.id}"> <xsl:value-of select="@xmi.label"/> </A> </B> </CODE> </TD>
        </TR>
      </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>

  <!--=================== METHOD SUMMARY ======================-->
  <xsl:if test="Interface.operation">
    <A NAME="{@xmi.id}:methods"><!-- --></A>

    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR BGCOLOR="87CEFA">
        <TD COLSPAN="2">
          <FONT SIZE="4"> <B> Method Summary </B> </FONT> </TD>
      </TR>

      <xsl:for-each select="Interface.operation/Operation">
        <xsl:sort select="@xmi.label"/>
        <TR BGCOLOR="#FFFFFF">
          <TD ALIGN="RIGHT" WIDTH="1%" NOWRAP="TRUE">
            <FONT SIZE="-1"> <CODE>
              <xsl:apply-templates select="Operation.returnType"/> <xsl:text> </xsl:text>
            </CODE> </FONT>
          </TD>
          <TD NOWRAP="TRUE"> <CODE>
            <B> <A HREF="#{@xmi.id}"> <xsl:value-of select="@xmi.label"/> </A> </B>
            (<xsl:for-each select="Operation.parameter/Parameter">
              <xsl:value-of select="Parameter.direction/@xmi.value"/> <xsl:text> </xsl:text>
              <xsl:apply-templates select="Parameter.type"/> <xsl:text> </xsl:text> <xsl:value-of select="@xmi.label"/>
              <xsl:if test="not(position()=last())">, </xsl:if>
            </xsl:for-each>)
          </CODE> </TD>
        </TR>
      </xsl:for-each>

    </TABLE>
    <BR/>

  </xsl:if>

  <!--============= RELATIONSHIP SUMMARY ======================-->
  <xsl:if test="Interface.associationEnd">

    <A NAME="{@xmi.id}:rels"><!-- --></A>

    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR BGCOLOR="87CEFA">
        <TD COLSPAN="2">
          <FONT SIZE="4"> <B> Relationship Summary </B> </FONT> </TD>
      </TR>

      <xsl:for-each select="Interface.associationEnd/AssociationEnd">
        <xsl:sort select="id(@xmi.idref)/../AssociationEnd[not(position()=1)]/AssociationEnd.name"/>
        <TR BGCOLOR="#FFFFFF">
          <TD WIDTH="1%">
            <CODE> <B>
              <A HREF="#{@xmi.idref}">
                <xsl:value-of select="id(@xmi.idref)/../AssociationEnd[not(position()=1)]/AssociationEnd.name"/>
              </A>
            </B> </CODE>
          </TD>

          <TD ALIGN="LEFT" WIDTH="1%" NOWRAP="TRUE">

            <xsl:variable name="ref-by-BOIntf"> <xsl:value-of select="id(@xmi.idref)/../AssociationEnd[position()=1]/AssociationEnd.type/BOInterface/@xmi.idref"/> </xsl:variable>
            <xsl:variable name="ref-to-BOIntf"> <xsl:value-of select="id(@xmi.idref)/../AssociationEnd[not(position()=1)]/AssociationEnd.type/BOInterface/@xmi.uuid|
                                                                      id(@xmi.idref)/../AssociationEnd[not(position()=1)]/AssociationEnd.type/BOInterface/@xmi.idref"/> </xsl:variable>
            <xsl:choose>

              <xsl:when test="id(@xmi.idref)[AssociationEnd.name]">   <!-- Only the 2nd AssocationEnd has a .name element -->
                <CODE>
                  <FONT SIZE="-1"> Referred by </FONT>
                  <!-- Assumes referred by only user defined BO Interfaces -->
                  <xsl:element name="A">
                    <xsl:attribute name="HREF">
                      #<xsl:value-of select="id(@xmi.idref)/../AssociationEnd[position()=1]/AssociationEnd.type/BOInterface/@xmi.idref"/>
                    </xsl:attribute>
                    <xsl:value-of select="id($ref-by-BOIntf)/@xmi.label"/>
                    <!-- Can also be done by nesting two id() functions like this: <xsl:value-of select='id(id(@xmi.idref)/../AssociationEnd[position()=1]/AssociationEnd.type/BOInterface/@xmi.idref)/@xmi.label'/> -->
                  </xsl:element>
                </CODE>
              </xsl:when>

              <xsl:otherwise>
                <CODE> <FONT SIZE="-1"> Refers to </FONT> </CODE>
                  <xsl:choose>

                    <!--  Framework interfaces or remote interfaces -->
                    <!-- <xsl:when test="$ref-to-BOIntf/../@xml:link"> -->
                    <xsl:when test="id(@xmi.idref)/../AssociationEnd[not(position()=1)]/AssociationEnd.type/BOInterface[@xml:link]">
                      <!--  Framework interfaces -->
                      <xsl:if test="contains($ref-to-BOIntf,'LOCAL:IVB:OBFrame:::')">
                        <CODE>
                          OBFrame:::<xsl:value-of select="substring-before(substring-after($ref-to-BOIntf,':::'),'::')"/>::<xsl:value-of select="id(@xmi.idref)/../AssociationEnd[not(position()=1)]/AssociationEnd.type/BOInterface/@xmi.label"/>
                        </CODE>
                      </xsl:if>

                      <!--  Remote interfaces -->
                      <xsl:if test="not(contains($ref-to-BOIntf,'LOCAL:IVB:OBFrame:::'))">
                        <FONT COLOR="RED"> <xsl:value-of select="id(@xmi.idref)/../AssociationEnd[not(position()=1)]/AssociationEnd.type/BOInterface/@xmi.label"/> </FONT>
                      </xsl:if>
                    </xsl:when>

                    <xsl:otherwise>
                      <!--  Local interfaces -->
                      <xsl:element name="A">
                        <xsl:attribute name="HREF">
                          #<xsl:value-of select="$ref-to-BOIntf"/>
                        </xsl:attribute>
                        <CODE> <xsl:value-of select="id($ref-to-BOIntf)/@xmi.label"/> </CODE>
                      </xsl:element>
                    </xsl:otherwise>

                  </xsl:choose>
              </xsl:otherwise>

            </xsl:choose>
          </TD>
        </TR>
      </xsl:for-each>

    </TABLE>
    <BR/>

  </xsl:if>

  <!--=================== CONSTRUCT DETAILS ===================-->
  <xsl:if test="Scope.declarator">
    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR>
        <TD BGCOLOR="87CEFA" COLSPAN="1">
          <FONT SIZE="4"> <B> Construct Details </B> </FONT>
        </TD>
      </TR>

      <xsl:for-each select="Scope.declarator">
        <xsl:call-template name="Constructs-Details"/>
      </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>

  <!-- =================== ATTRIBUTE DETAILS ===================-->
  <xsl:if test="Interface.attribute">

    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR>
        <TD BGCOLOR="87CEFA" COLSPAN="1">
          <FONT SIZE="4"> <B> Attribute Details </B> </FONT>
        </TD>
      </TR>

      <xsl:for-each select="Interface.attribute/Attribute">
        <xsl:sort select="@xmi.label"/>
        <TR> <TD>
          <A name="{@xmi.uuid}"><!-- --></A>

          <FONT SIZE="4"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT> <P/>
          <NOBR> <CODE>
            <xsl:apply-templates select="Attribute.type"/> <xsl:text> </xsl:text>
            <B> <xsl:value-of select="@xmi.label"/> </B>
          </CODE> </NOBR>

          <P/>
          <B> Read only: </B> <xsl:value-of select="Attribute.isReadOnly/@xmi.value"/> <BR/>
          <B> Overrideable: </B> <xsl:value-of select="Attribute.implPrototype/AttributeImpl/AttributeImpl.isOverrideable/@xmi.value"/> <BR/>
          <NOBR> <B> Initial Cpp value: </B> <CODE> <xsl:value-of select="Attribute.implPrototype/AttributeImpl/AttributeImpl.initialCppValue"/> </CODE> </NOBR> <BR/>
          <NOBR> <B> Initial Java value: </B> <CODE> <xsl:value-of select="Attribute.implPrototype/AttributeImpl/AttributeImpl.initialJavaValue"/> </CODE> </NOBR>
        <BR/> <BR/>

        </TD> </TR>
      </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>

  <!--=================== METHOD DETAILS =======================-->
  <xsl:if test="Interface.operation">

    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR>
        <TD BGCOLOR="87CEFA" COLSPAN="1">
          <FONT SIZE="4"> <B> Method Details </B> </FONT>
        </TD>
      </TR>

    <xsl:for-each select="Interface.operation/Operation">
      <xsl:sort select="@xmi.label"/>
      <TR> <TD>
        <A name="{@xmi.id}"><!-- --></A>

        <FONT SIZE="4"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT> <P/>
        <NOBR> <CODE>
          <xsl:apply-templates select="Operation.returnType"/> <xsl:text> </xsl:text>
          <B> <xsl:value-of select="@xmi.label"/> </B>
          (<xsl:for-each select="Operation.parameter/Parameter">
            <xsl:value-of select="Parameter.direction/@xmi.value"/> <xsl:text> </xsl:text>
            <xsl:apply-templates select="Parameter.type"/> <xsl:text> </xsl:text> <xsl:value-of select="@xmi.label"/>
            <xsl:if test="not(position()=last())">, </xsl:if>
          </xsl:for-each>)
        </CODE> </NOBR>

        <P/>
        <B> One-way: </B><xsl:value-of select="Operation.isOneWay/@xmi.value"/> <BR/>
        <B> Overrideable: </B> <xsl:value-of select="Operation.implPrototype/OperationImpl/OperationImpl.isOverrideable/@xmi.value"/> <BR/>
        <B> Constant method: </B> <xsl:value-of select="Operation.implPrototype/OperationImpl/OperationImpl.isConstantMethod/@xmi.value"/> <BR/>
        <B> Context: </B> <xsl:value-of select="Operation.context"/>  <BR/>
        <B> Exceptions: </B>

        <xsl:for-each select="Operation.exception/Exception">
          <!-- This way the Framework exceptions are listed first -->
            <xsl:sort select="@xmi.uuid"/>
            <xsl:sort select="@xmi.label"/>
            <!-- For Framework objects -->
            <xsl:if test="contains(@xmi.uuid,'LOCAL:IVB:OBFrame:::')">
              <DD> OBFrame:::<xsl:value-of select="substring-before(substring-after(@xmi.uuid,':::'),'::')"/>::<xsl:value-of select="@xmi.label"/> </DD>
            </xsl:if>
        </xsl:for-each>

        <xsl:for-each select="Operation.exception/Exception">
          <xsl:choose>
            <xsl:when test='@xml:link'>
               <!-- For remote user-defined exceptions -->
               <xsl:if test="not(contains(@xmi.uuid,'LOCAL:IVB:OBFrame:::'))">
                 <DD> <FONT COLOR="RED"> <xsl:value-of select="@xmi.label"/> </FONT> </DD>
               </xsl:if>
            </xsl:when>

            <xsl:otherwise>
              <!-- For local user-defined exceptions -->
              <DD> <A href="#{@xmi.idref}"> <xsl:value-of select='id(@xmi.idref)/@xmi.label'/> </A> </DD>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>

        <BR/>  <BR/>

      </TD> </TR>

    </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>

  <!--============= RELATIONSHIP DETAILS ======================-->
  <xsl:if test="Interface.associationEnd">

    <xsl:for-each select="Interface.associationEnd/AssociationEnd">
        <!-- The details of the relationship will not be displayed in the -->
        <!-- BO Interface that is being referred to.                      -->
        <!-- It will be displayed in the originating interface.           -->

      <xsl:if test="not(id(@xmi.idref)/from-self[AssociationEnd.name])">

        <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
          <TR BGCOLOR="87CEFA">
            <TD COLSPAN="2">
              <FONT SIZE="4"> <B> Relationship Details </B> </FONT>
            </TD>
          </TR>

          <xsl:sort select="id(@xmi.idref)/../AssociationEnd[not(position()=1)]/AssociationEnd.name"/>

          <TR> <TD>
            <xsl:apply-templates select="id(@xmi.idref)/from-ancestors(Association)"/>
          </TD> </TR>

        </TABLE>
        <BR/>
      </xsl:if>

    </xsl:for-each>

  </xsl:if>

</xsl:template>


<!--==================================================================-->
<!--  Repository.idlNamespace/DOInterface                             -->
<!--==================================================================-->
<xsl:template match="DOInterface">
  <A NAME="{@xmi.id}"><!-- --></A>
  <TABLE BORDER="1" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
    <TR>
      <TD BGCOLOR="6FB6E2" COLSPAN="1">
        <FONT SIZE="3"> <B> <I>DO Interface: </I> </B> <BR/> </FONT>
        <xsl:if test="from-ancestors(Module)"> <FONT SIZE="5"> <B> <xsl:value-of select="from-ancestors(Module)/@xmi.label"/>::</B> </FONT> </xsl:if>
        <FONT SIZE="5"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT>
        <BR/>
        <FONT SIZE="-1">
          <!-- Menu -->
          <xsl:choose>
            <xsl:when test="Scope.declarator"> <A HREF="#{@xmi.id}:constructs">Constructs</A> | </xsl:when>
            <xsl:otherwise>Constructs | </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="Interface.attribute"> <A HREF="#{@xmi.id}:attributes">Attributes</A> | </xsl:when>
            <xsl:otherwise>Attributes | </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="Interface.operation"> <A HREF="#{@xmi.id}:methods">Methods</A> </xsl:when>
            <xsl:otherwise>Methods</xsl:otherwise>
          </xsl:choose>

        </FONT>
      </TD>
    </TR>
  </TABLE>

  <KBD> <xsl:value-of select="Scope.comments"/> </KBD>

  <DL>
    <B> Inherits from: </B>

    <xsl:for-each select="Interface.parent/DOInterface">
      <xsl:sort select="id(@xmi.idref)/@xmi.label|@xmi.label"/>

      <xsl:choose>
        <xsl:when test='@xml:link'>
           <!-- For remote user-defined DO Interfaces -->
           <xsl:if test="not(contains(@xmi.uuid,'LOCAL:IVB:OBFrame:::'))">
             <DD> <FONT COLOR="RED"> <xsl:value-of select="@xmi.label"/> </FONT> </DD>
           </xsl:if>
        </xsl:when>

        <xsl:otherwise>
          <!-- For local user-defined DO Interfaces -->
          <DD> <A href="#{@xmi.idref}"> <xsl:value-of select='id(@xmi.idref)/@xmi.label'/> </A> </DD>
        </xsl:otherwise>
      </xsl:choose>

    </xsl:for-each>

  </DL>

  <!--=================== CONSTRUCT SUMMARY ===================-->
  <xsl:if test="Scope.declarator">
    <A NAME="{@xmi.id}:constructs"><!-- --></A>

    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR BGCOLOR="87CEFA">
        <TD COLSPAN="2">
          <FONT SIZE="4"> <B> Constructs Summary </B> </FONT> </TD>
      </TR>


      <xsl:for-each select="Scope.declarator">
        <xsl:call-template name="Constructs-Summary"/>
      </xsl:for-each>
    </TABLE>
    <BR/>
  </xsl:if>

  <!--================== ATTRIBUTE SUMMARY ====================-->
  <xsl:if test="Interface.attribute">
    <A NAME="{@xmi.id}:attributes"><!-- --></A>
    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR BGCOLOR="87CEFA">
        <TD COLSPAN="2">
          <FONT SIZE="4"> <B> Attribute Summary </B> </FONT> </TD>
      </TR>

      <xsl:for-each select="Interface.attribute/Attribute">
        <xsl:sort select="@xmi.label"/>
        <TR BGCOLOR="#FFFFFF">
          <TD ALIGN="RIGHT" WIDTH="1%" NOWRAP="TRUE">
            <FONT SIZE="-1"> <CODE>
              <xsl:apply-templates select="Attribute.type"/>
            </CODE> </FONT>
          </TD>
          <TD> <CODE> <B> <A HREF="#{@xmi.id}"> <xsl:value-of select="@xmi.label"/> </A> </B> </CODE> </TD>
        </TR>
      </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>

  <!--=================== METHOD SUMMARY ======================-->
  <xsl:if test="Interface.operation">
    <A NAME="{@xmi.id}:methods"><!-- --></A>

    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR BGCOLOR="87CEFA">
        <TD COLSPAN="2">
          <FONT SIZE="4"> <B> Method Summary </B> </FONT> </TD>
      </TR>

      <xsl:for-each select="Interface.operation/Operation">
        <xsl:sort select="@xmi.label"/>
        <TR BGCOLOR="#FFFFFF">
          <TD ALIGN="RIGHT" WIDTH="1%" NOWRAP="TRUE">
            <FONT SIZE="-1"> <CODE>
              <xsl:apply-templates select="Operation.returnType"/> <xsl:text> </xsl:text>
            </CODE> </FONT>
          </TD>
          <TD NOWRAP="TRUE"> <CODE>
            <B> <A HREF="#{@xmi.id}"> <xsl:value-of select="@xmi.label"/> </A> </B>
            (<xsl:for-each select="Operation.parameter/Parameter">
              <xsl:value-of select="Parameter.direction/@xmi.value"/> <xsl:text> </xsl:text>
              <xsl:apply-templates select="Parameter.type"/> <xsl:text> </xsl:text> <xsl:value-of select="@xmi.label"/>
              <xsl:if test="not(position()=last())">, </xsl:if>
            </xsl:for-each>)
          </CODE> </TD>
        </TR>
      </xsl:for-each>

    </TABLE>
    <BR/>

  </xsl:if>

  <!--=================== CONSTRUCT DETAILS ===================-->
  <xsl:if test="Scope.declarator">
    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR>
        <TD BGCOLOR="87CEFA" COLSPAN="1">
          <FONT SIZE="4"> <B> Construct Details </B> </FONT>
        </TD>
      </TR>

      <!--======= CONSTANTS =======-->
      <xsl:for-each select="Scope.declarator/Constant">
        <xsl:sort select="@xmi.label"/>
        <TR> <TD>
          <A NAME="{@xmi.id}"><!-- --></A>
          <FONT SIZE="-1"> <B> <I> Constant: </I> </B> <BR/> </FONT>
          <FONT SIZE="4"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT>
          <P/>
          <NOBR> <B> Type: </B> <CODE> <xsl:apply-templates select="Constant.type"/> </CODE> </NOBR> <BR/>
          <NOBR> <B> Cpp value: </B> <CODE> <xsl:value-of select="Constant.cppInitializer"/> </CODE> </NOBR> <BR/>
          <NOBR> <B> Java value: </B> <CODE> <xsl:value-of select="Constant.javaInitializer"/> </CODE> </NOBR>
          <BR/> <BR/>
        </TD> </TR>
      </xsl:for-each>

      <!--======== TYPEDEF ========-->
      <xsl:for-each select="Scope.declarator/Typedef">
        <xsl:sort select="@xmi.label"/>
        <TR> <TD>
          <A NAME="{@xmi.id}"><!-- --></A>
          <FONT SIZE="-1"> <B> <I> TypeDef: </I> </B> <BR/> </FONT>
          <FONT SIZE="4"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT>
          <P/> <NOBR> <B> Type: </B> <CODE> <xsl:apply-templates select="Typedef.type"/> </CODE> </NOBR>
          <BR/> <BR/>
        </TD> </TR>
      </xsl:for-each>

      <!--======== UNION ========-->
      <xsl:for-each select="Scope.declarator/Union">
        <xsl:sort select="@xmi.label"/>
        <TR> <TD>
        <A NAME="{@xmi.id}"><!-- --></A>
        <FONT SIZE="-1"> <B> <I> Union: </I> </B> <BR/> </FONT>
        <FONT SIZE="4"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT> <P/>
        <DL>
          <B> Switch specifier: </B> <CODE> <xsl:apply-templates select="Union.switchSpecifier"/> </CODE>
          <DT> <B> Members: </B> </DT>
          <DD>
            <UL>
              <xsl:for-each select="Union.member/UTypeDeclarator">
                <xsl:sort select="@xmi.label"/>
                <LI>
                  <A NAME="{@xmi.uuid}"> <xsl:value-of select="@xmi.label"/> </A>
                  <DD> <NOBR> <B> Type: </B> <CODE> <xsl:apply-templates select="TypeDeclarator.type"/> </CODE> </NOBR> </DD>
                  <DD> <B> Case label: </B> <CODE> <xsl:value-of select="UTypeDeclarator.caseLabel"/> </CODE> </DD>
                </LI>
              </xsl:for-each>
            </UL>
          </DD>
        </DL>
        </TD> </TR>
      </xsl:for-each>

      <!--====== ENUMERATION ======-->
      <xsl:for-each select="Scope.declarator/Enumeration">
        <xsl:sort select="@xmi.label"/>
        <TR> <TD>
          <A NAME="{@xmi.id}"><!-- --></A>
          <FONT SIZE="-1"> <B> <I> Enumeration: </I> </B> <BR/> </FONT>
          <FONT SIZE="4"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT> <P/>
          <DL>
            <DT> <B> Members: </B> </DT>
              <DD>
                <xsl:for-each select="Enumeration.member/EnumMember">
                  <xsl:sort select="@xmi.label"/>
                  <DD>
                    <A NAME="{@xmi.uuid}"> <xsl:value-of select="@xmi.label"/> </A>
                  </DD>
                </xsl:for-each>
               </DD>
          </DL>
        </TD> </TR>
      </xsl:for-each>

      <!--======== STRUCT ========-->
      <xsl:for-each select="Scope.declarator/Struct">
        <TR> <TD>
          <A NAME="{@xmi.id}"><!-- --></A>
          <xsl:sort select="@xmi.label"/>
          <FONT SIZE="-1"> <B> <I> Struct: </I> </B> <BR/> </FONT>
          <FONT SIZE="4"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT> <P/>
          <DL>
            <DT> <B> Members: </B> </DT>
            <DD>
              <UL>
                <xsl:for-each select="Struct.member/TypeDeclarator">
                  <xsl:sort select="@xmi.label"/>
                  <LI>
                    <A NAME="{@xmi.uuid}"> <xsl:value-of select="@xmi.label"/> </A>
                    <DD> <NOBR> <B> Type: </B> <CODE> <xsl:apply-templates select="TypeDeclarator.type"/> </CODE> </NOBR> </DD>
                  </LI>
                </xsl:for-each>
              </UL>
            </DD>
          </DL>
        </TD> </TR>
      </xsl:for-each>

      <!--======= EXCEPTION =======-->
      <xsl:for-each select="Scope.declarator/Exception">
        <xsl:sort select="@xmi.label"/>
        <TR> <TD>
          <A NAME="{@xmi.id}"><!-- --></A>
          <FONT SIZE="-1"> <B> <I> Exception: </I> </B> <BR/> </FONT>
          <FONT SIZE="4"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT> <P/>
          <DL>
            <DT> <B> Members: </B> </DT>
            <DD>
              <UL>
                <xsl:for-each select="Exception.member/TypeDeclarator">
                  <xsl:sort select="@xmi.label"/>
                  <LI>
                    <A NAME="{@xmi.uuid}"> <xsl:value-of select="@xmi.label"/> </A>
                    <DD> <NOBR> <B> Type: </B> <CODE> <xsl:apply-templates select="TypeDeclarator.type"/> </CODE> </NOBR> </DD>
                  </LI>
                </xsl:for-each>
              </UL>
            </DD>
          </DL>
        </TD> </TR>
      </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>

  <!-- =================== ATTRIBUTE DETAILS ===================-->
  <xsl:if test="Interface.attribute">

    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR>
        <TD BGCOLOR="87CEFA" COLSPAN="1">
          <FONT SIZE="4"> <B> Attribute Details </B> </FONT>
        </TD>
      </TR>

      <xsl:for-each select="Interface.attribute/Attribute">
        <xsl:sort select="@xmi.label"/>
        <TR> <TD>
          <A name="{@xmi.uuid}"><!-- --></A>

          <FONT SIZE="4"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT> <P/>
          <NOBR> <CODE>
            <xsl:apply-templates select="Attribute.type"/> <xsl:text> </xsl:text>
            <B> <xsl:value-of select="@xmi.label"/> </B>
          </CODE> </NOBR>

          <P/>
          <B> Read only: </B> <xsl:value-of select="Attribute.isReadOnly/@xmi.value"/> <BR/>
          <B> Overrideable: </B> <xsl:value-of select="Attribute.implPrototype/AttributeImpl/AttributeImpl.isOverrideable/@xmi.value"/> <BR/>
          <NOBR> <B> Initial Cpp value: </B> <CODE> <xsl:value-of select="Attribute.implPrototype/AttributeImpl/AttributeImpl.initialCppValue"/> </CODE> </NOBR> <BR/>
          <NOBR> <B> Initial Java value: </B> <CODE> <xsl:value-of select="Attribute.implPrototype/AttributeImpl/AttributeImpl.initialJavaValue"/> </CODE> </NOBR>
        <BR/> <BR/>

        </TD> </TR>
      </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>

  <!--=================== METHOD DETAILS =======================-->
  <xsl:if test="Interface.operation">

    <TABLE BORDER="1" CELLPADDING="3" CELLSPACING="0" WIDTH="100%">
      <TR>
        <TD BGCOLOR="87CEFA" COLSPAN="1">
          <FONT SIZE="4"> <B> Method Details </B> </FONT>
        </TD>
      </TR>

    <xsl:for-each select="Interface.operation/Operation">
      <xsl:sort select="@xmi.label"/>
      <TR> <TD>
        <A name="{@xmi.id}"><!-- --></A>

        <FONT SIZE="4"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT> <P/>
        <NOBR> <CODE>
          <xsl:apply-templates select="Operation.returnType"/> <xsl:text> </xsl:text>
          <B> <xsl:value-of select="@xmi.label"/> </B>
          (<xsl:for-each select="Operation.parameter/Parameter">
            <xsl:value-of select="Parameter.direction/@xmi.value"/> <xsl:text> </xsl:text>
            <xsl:apply-templates select="Parameter.type"/> <xsl:text> </xsl:text> <xsl:value-of select="@xmi.label"/>
            <xsl:if test="not(position()=last())">, </xsl:if>
          </xsl:for-each>)
        </CODE> </NOBR>

        <P/>
        <B> One-way: </B><xsl:value-of select="Operation.isOneWay/@xmi.value"/> <BR/>
        <B> Overrideable: </B> <xsl:value-of select="Operation.implPrototype/OperationImpl/OperationImpl.isOverrideable/@xmi.value"/> <BR/>
        <B> Constant method: </B> <xsl:value-of select="Operation.implPrototype/OperationImpl/OperationImpl.isConstantMethod/@xmi.value"/> <BR/>
        <B> Context: </B> <xsl:value-of select="Operation.context"/>  <BR/>
        <B> Exceptions: </B>

        <xsl:for-each select="Operation.exception/Exception">
          <!-- This way the Framework exceptions are listed first -->
            <xsl:sort select="@xmi.uuid"/>
            <xsl:sort select="@xmi.label"/>
            <!-- For Framework objects -->
            <xsl:if test="contains(@xmi.uuid,'LOCAL:IVB:OBFrame:::')">
              <DD> OBFrame:::<xsl:value-of select="substring-before(substring-after(@xmi.uuid,':::'),'::')"/>::<xsl:value-of select="@xmi.label"/> </DD>
            </xsl:if>
        </xsl:for-each>

        <xsl:for-each select="Operation.exception/Exception">
          <xsl:choose>
            <xsl:when test='@xml:link'>
               <!-- For remote user-defined exceptions -->
               <xsl:if test="not(contains(@xmi.uuid,'LOCAL:IVB:OBFrame:::'))">
                 <DD> <FONT COLOR="RED"> <xsl:value-of select="@xmi.label"/> </FONT> </DD>
               </xsl:if>
            </xsl:when>

            <xsl:otherwise>
              <!-- For local user-defined exceptions -->
              <DD> <A href="#{@xmi.idref}"> <xsl:value-of select='id(@xmi.idref)/@xmi.label'/> </A> </DD>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>

        <BR/>  <BR/>

      </TD> </TR>

    </xsl:for-each>

    </TABLE>
    <BR/>
  </xsl:if>


</xsl:template>


<!--==================================================================-->
<!--  Repository.allAssociations                                      -->
<!--==================================================================-->

<xsl:template match="Repository.allAssociations/Association">

  <!-- The way relationships are organized is that the second AssociationEnd -->
  <!-- contains the Interface object that is referred to by the BO Interface -->
  <!-- in the first AssocationEnd.                                           -->

  <!-- Also, the name of the relationship also resides in the second         -->
  <!-- AssociationEnd                                                        -->

  <A NAME="{Association.connection/AssociationEnd/@xmi.id}"><!-- --></A>
  <A NAME="{Association.connection/AssociationEnd[not(position()=1)]/@xmi.id}"><!-- --></A>

  <FONT SIZE="5">
    <B> <xsl:value-of select='Association.connection/AssociationEnd[not(position()=1)]/AssociationEnd.name'/> </B>
  </FONT>

  <P/>

  <xsl:for-each select="Association.connection/AssociationEnd">
    <PRE>
      <xsl:choose>

        <xsl:when test="position()=1">
          <xsl:if test="AssociationEnd.type/BOInterface[@xml:link]">
            <FONT COLOR="RED">
<xsl:value-of select="AssociationEnd.type/BOInterface/@xmi.uuid"/>
            </FONT>
          </xsl:if>
          <xsl:if test="not(AssociationEnd.type/BOInterface[@xml:link])">
<A href="#{AssociationEnd.type/BOInterface/@xmi.idref}"> <xsl:value-of select='id(AssociationEnd.type/BOInterface/@xmi.idref)/@xmi.label'/> </A>
          </xsl:if>
          <CODE>
     |
     | refers to
     |
     v
          </CODE>
        </xsl:when>

        <xsl:otherwise>

          <xsl:choose>

            <xsl:when test="AssociationEnd.type/BOInterface[@xml:link]">

              <!-- Framework interfaces -->
              <xsl:if test="contains(AssociationEnd.type/BOInterface/@xmi.uuid,'LOCAL:IVB:OBFrame:::')">
OBFrame:::<xsl:value-of select="substring-before(substring-after(AssociationEnd.type/BOInterface/@xmi.uuid,':::'),'::')"/>::<xsl:value-of select="AssociationEnd.type/BOInterface/@xmi.label"/>
              </xsl:if>

              <!-- Remote interfaces -->
              <xsl:if test="not(contains(AssociationEnd.type/BOInterface/@xmi.uuid,'LOCAL:IVB:OBFrame:::'))">
                <FONT COLOR="RED">
<xsl:value-of select="AssociationEnd.type/BOInterface/@xmi.uuid"/>
                </FONT>
              </xsl:if>

            </xsl:when>

            <xsl:otherwise>
              <!-- Local interfaces -->
<A href="#{AssociationEnd.type/BOInterface/@xmi.idref}"> <xsl:value-of select='id(AssociationEnd.type/BOInterface/@xmi.idref)/@xmi.label'/> </A>
            </xsl:otherwise>

          </xsl:choose>

        </xsl:otherwise>

      </xsl:choose>

    </PRE>

  </xsl:for-each>

  <DL>
    <DT> <P/> <B> Methods: </B> </DT>
    <DD>
      <xsl:for-each select="Association.connection/AssociationEnd[not(position()=1)]/AssociationEnd.endAccess/EndAccess/EndAccess.operation/Operation">
        <xsl:sort select="id(@xmi.idref)/@xmi.label"/>
        <A HREF="#{@xmi.idref}"> <xsl:value-of select="id(@xmi.idref)/@xmi.label"/> </A> <BR/>
      </xsl:for-each>
    </DD>
  </DL>

</xsl:template>


<!--==================================================================-->
<!--  Type                                                            -->
<!--==================================================================-->

<xsl:template match="Attribute.type|Parameter.type|Operation.returnType|
                     Constant.type |Typedef.type  |TypeDeclarator.type |Union.switchSpecifier">

  <xsl:choose>

    <!-- Framework Interfaces -->
    <xsl:when test="InterfaceType/InterfaceType.interface/BOInterface/Interface.interfaceType">

      <!-- Shorten the text for method return types or parameters. -->
      <!-- Otherwise, the length will be too long to fit properly in a table. -->
      <xsl:if test="from-ancestors(Operation)">
        <xsl:value-of select="substring-before(substring-after(InterfaceType/InterfaceType.interface/BOInterface/@xmi.uuid,':::'),'::')"/>::<xsl:value-of select="InterfaceType/InterfaceType.interface/BOInterface/@xmi.label"/>
      </xsl:if>

      <xsl:if test="not(from-ancestors(Operation))">
        OBFrame:::<xsl:value-of select="substring-before(substring-after(InterfaceType/InterfaceType.interface/BOInterface/@xmi.uuid,':::'),'::')"/>::<xsl:value-of select="InterfaceType/InterfaceType.interface/BOInterface/@xmi.label"/>
      </xsl:if>

    </xsl:when>

    <!-- User-Defined Interfaces -->
    <xsl:when test="InterfaceType/InterfaceType.interface/BOInterface">
      <!-- For local objects -->
      <xsl:if test="InterfaceType/InterfaceType.interface/BOInterface[@xmi.idref]">
        <A href="#{InterfaceType/InterfaceType.interface/BOInterface/@xmi.idref}"> <xsl:value-of select='id(InterfaceType/InterfaceType.interface/BOInterface/@xmi.idref)/@xmi.label'/> </A>
      </xsl:if>
      <!-- For remote objects -->
      <xsl:if test="InterfaceType/InterfaceType.interface/BOInterface[@xml:link]"> <FONT COLOR="RED"> <xsl:value-of select="InterfaceType/InterfaceType.interface/BOInterface/@xmi.label"/> </FONT> </xsl:if>
    </xsl:when>

    <!-- Enumerations -->
    <xsl:when test="DeclaratorType/DeclaratorType.declarator/Enumeration">
      <!-- For local objects -->
      <xsl:if test="DeclaratorType/DeclaratorType.declarator/Enumeration[@xmi.idref]">
        <A href="#{DeclaratorType/DeclaratorType.declarator/Enumeration/@xmi.idref}"><xsl:value-of select='id(DeclaratorType/DeclaratorType.declarator/Enumeration/@xmi.idref)/@xmi.label'/> </A>
      </xsl:if>
      <!-- For remote objects -->
      <xsl:if test="DeclaratorType/DeclaratorType.declarator/Enumeration[@xml:link]"> <FONT COLOR="RED"> <xsl:value-of select="DeclaratorType/DeclaratorType.declarator/Enumeration/@xmi.label"/> </FONT> </xsl:if>
    </xsl:when>

    <!-- TypeDefs using FrameWork Interfaces -->
    <xsl:when test="DeclaratorType/DeclaratorType.declarator/Typedef/Declarator.declaratorType">
      <!-- Shorten the text for method return types or parameters. -->
      <!-- Otherwise, the length will be too long to fit properly in a table. -->
      <xsl:if test="from-ancestors(Operation)">
        <xsl:value-of select="substring-before(substring-after(DeclaratorType/DeclaratorType.declarator/Typedef/@xmi.uuid,':::'),'::')"/>::<xsl:value-of select="DeclaratorType/DeclaratorType.declarator/Typedef/@xmi.label"/>
      </xsl:if>

      <xsl:if test="not(from-ancestors(Operation))">
        OBFrame:::<xsl:value-of select="substring-before(substring-after(DeclaratorType/DeclaratorType.declarator/Typedef/@xmi.uuid,':::'),'::')"/>::<xsl:value-of select="DeclaratorType/DeclaratorType.declarator/Typedef/@xmi.label"/>
      </xsl:if>
    </xsl:when>

    <!-- TypeDefs -->
    <xsl:when test="DeclaratorType/DeclaratorType.declarator/Typedef">
      <!-- For local objects -->
      <xsl:if test="DeclaratorType/DeclaratorType.declarator/Typedef[@xmi.idref]">
        <A href="#{DeclaratorType/DeclaratorType.declarator/Typedef/@xmi.idref}"> <xsl:value-of select='id(DeclaratorType/DeclaratorType.declarator/Typedef/@xmi.idref)/@xmi.label'/> </A>
      </xsl:if>
      <!-- For remote objects -->
      <xsl:if test="DeclaratorType/DeclaratorType.declarator/Typedef[@xml:link]"> <FONT COLOR="RED"> <xsl:value-of select="DeclaratorType/DeclaratorType.declarator/Typedef/@xmi.label"/> </FONT> </xsl:if>
    </xsl:when>

    <!-- Structs -->
    <xsl:when test="DeclaratorType/DeclaratorType.declarator/Struct">
      <!-- For local objects -->
      <xsl:if test="DeclaratorType/DeclaratorType.declarator/Struct[@xmi.idref]">
        <A href="#{DeclaratorType/DeclaratorType.declarator/Struct/@xmi.idref}"> <xsl:value-of select='id(DeclaratorType/DeclaratorType.declarator/Struct/@xmi.idref)/@xmi.label'/> </A>
      </xsl:if>
      <!-- For remote objects -->
      <xsl:if test="DeclaratorType/DeclaratorType.declarator/Struct[@xml:link]"> <FONT COLOR="RED"> <xsl:value-of select="DeclaratorType/DeclaratorType.declarator/Struct/@xmi.label"/> </FONT> </xsl:if>
    </xsl:when>

    <!-- Unions -->
    <xsl:when test="DeclaratorType/DeclaratorType.declarator/Union">
      <!-- For local objects -->
      <xsl:if test="DeclaratorType/DeclaratorType.declarator/Union[@xmi.idref]">
        <A href="#{DeclaratorType/DeclaratorType.declarator/Union/@xmi.idref}"> <xsl:value-of select='id(DeclaratorType/DeclaratorType.declarator/Union/@xmi.idref)/@xmi.label'/> </A>
      </xsl:if>
      <!-- For remote objects -->
      <xsl:if test="DeclaratorType/DeclaratorType.declarator/Union[@xml:link]"> <FONT COLOR="RED"> <xsl:value-of select="DeclaratorType/DeclaratorType.declarator/Union/@xmi.label"/> </FONT> </xsl:if>
    </xsl:when>

    <!-- Primitive Types -->
    <xsl:when test="CorbaType">
      <xsl:value-of select="CorbaType/CorbaType.kind/@xmi.value"/>
    </xsl:when>

    <xsl:otherwise>
      <FONT COLOR="RED"> <B>THIS TYPE IS NOT SUPPORTED IN VIEW.XSL !!!</B> </FONT>
    </xsl:otherwise>

  </xsl:choose>

</xsl:template>


<!--==================================================================-->
<!--  Templates: Constructs-Summary                                   -->
<!--==================================================================-->
<xsl:template name="Constructs-Summary">

      <!--====== CONSTANTS ======-->
      <xsl:for-each select="Constant">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Constant-Summary"/>
      </xsl:for-each>

      <!--======= TYPEDEF =======-->
      <xsl:for-each select="Typedef">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Typedef-Summary"/>
      </xsl:for-each>

      <!--======== UNION ========-->
      <xsl:for-each select="Union">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Union-Summary"/>
      </xsl:for-each>

      <!--===== ENUMERATION =====-->
      <xsl:for-each select="Enumeration">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Enumeration-Summary"/>
      </xsl:for-each>

      <!--======= STRUCT =======-->
      <xsl:for-each select="Struct">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Struct-Summary"/>
      </xsl:for-each>

      <!--====== EXCEPTION ======-->
      <xsl:for-each select="Exception">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Exception-Summary"/>
      </xsl:for-each>

</xsl:template>

<!--==================================================================-->
<!--  Templates: Constructs-Details                                   -->
<!--==================================================================-->
<xsl:template name="Constructs-Details">

      <!--====== CONSTANTS ======-->
      <xsl:for-each select="Constant">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Constant-Details"/>
      </xsl:for-each>

      <!--======= TYPEDEF =======-->
      <xsl:for-each select="Typedef">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Typedef-Details"/>
      </xsl:for-each>

      <!--======== UNION ========-->
      <xsl:for-each select="Union">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Union-Details"/>
      </xsl:for-each>

      <!--===== ENUMERATION =====-->
      <xsl:for-each select="Enumeration">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Enumeration-Details"/>
      </xsl:for-each>

      <!--======= STRUCT =======-->
      <xsl:for-each select="Struct">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Struct-Details"/>
      </xsl:for-each>

      <!--====== EXCEPTION ======-->
      <xsl:for-each select="Exception">
        <xsl:sort select="@xmi.label"/>
        <xsl:call-template name="Exception-Details"/>
      </xsl:for-each>

</xsl:template>


<!--==================================================================-->
<!--  Templates: Constant                                             -->
<!--==================================================================-->
<xsl:template name="Constant-Summary">
  <TR BGCOLOR="#FFFFFF">
    <TD ALIGN="CENTER" WIDTH="1%">
      <FONT SIZE="-1"> <CODE>CONSTANT</CODE> </FONT>
    </TD>
    <TD>
      <CODE>
        <FONT SIZE="-1"> <xsl:apply-templates select="Constant.type"/> </FONT> <xsl:text> </xsl:text>
          <B> <A HREF="#{@xmi.id}"> <xsl:value-of select="@xmi.label"/> </A> </B>
      </CODE>
    </TD>
  </TR>
</xsl:template>

<xsl:template name="Constant-Details">
  <TR> <TD>
    <A NAME="{@xmi.id}"><!-- --></A>
    <FONT SIZE="-1"> <B> <I> Constant: </I> </B> <BR/> </FONT>
    <FONT SIZE="4"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT>
    <P/>
    <NOBR> <B> Type: </B> <CODE> <xsl:apply-templates select="Constant.type"/> </CODE> </NOBR> <BR/>
    <NOBR> <B> Cpp value: </B> <CODE> <xsl:value-of select="Constant.cppInitializer"/> </CODE> </NOBR> <BR/>
    <NOBR> <B> Java value: </B> <CODE> <xsl:value-of select="Constant.javaInitializer"/> </CODE> </NOBR>
    <BR/> <BR/>
  </TD> </TR>
</xsl:template>


<!--==================================================================-->
<!--  Templates: Typedef                                              -->
<!--==================================================================-->
<xsl:template name="Typedef-Summary">
  <TR BGCOLOR="#FFFFFF">
    <TD ALIGN="CENTER" WIDTH="1%">
      <FONT SIZE="-1"> <CODE>TYPEDEF</CODE> </FONT>
    </TD>
    <TD>
      <CODE>
        <FONT SIZE="-1"> <xsl:apply-templates select="Typedef.type"/> </FONT> <xsl:text> </xsl:text>
        <B> <A HREF="#{@xmi.id}"> <xsl:value-of select="@xmi.label"/> </A> </B>
      </CODE>
    </TD>
  </TR>
</xsl:template>

<xsl:template name="Typedef-Details">
  <TR> <TD>
    <A NAME="{@xmi.id}"><!-- --></A>
    <FONT SIZE="-1"> <B> <I> TypeDef: </I> </B> <BR/> </FONT>
    <FONT SIZE="4"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT>
    <P/> <NOBR> <B> Type: </B> <CODE> <xsl:apply-templates select="Typedef.type"/> </CODE> </NOBR>
    <BR/> <BR/>
  </TD> </TR>
</xsl:template>


<!--==================================================================-->
<!--  Templates: Union                                                -->
<!--==================================================================-->
<xsl:template name="Union-Summary">
  <TR BGCOLOR="#FFFFFF">
    <TD ALIGN="CENTER" WIDTH="1%">
      <FONT SIZE="-1"> <CODE>UNION</CODE> </FONT>
    </TD>
    <TD>
      <CODE>
        <FONT SIZE="-1"> <xsl:apply-templates select="Union.switchSpecifier"/> </FONT> <xsl:text> </xsl:text>
        <B> <A HREF="#{@xmi.id}"> <xsl:value-of select="@xmi.label"/> </A> </B>
      </CODE>
    </TD>
  </TR>
</xsl:template>

<xsl:template name="Union-Details">
  <TR> <TD>
    <A NAME="{@xmi.id}"><!-- --></A>
    <FONT SIZE="-1"> <B> <I> Union: </I> </B> <BR/> </FONT>
    <FONT SIZE="4"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT> <P/>
    <DL>
      <B> Switch specifier: </B> <CODE> <xsl:apply-templates select="Union.switchSpecifier"/> </CODE>
      <DT> <B> Members: </B> </DT>
      <DD>
        <UL>
          <xsl:for-each select="Union.member/UTypeDeclarator">
            <xsl:sort select="@xmi.label"/>
            <LI>
              <A NAME="{@xmi.uuid}"> <xsl:value-of select="@xmi.label"/> </A>
              <DD> <NOBR> <B> Type: </B> <CODE> <xsl:apply-templates select="TypeDeclarator.type"/> </CODE> </NOBR> </DD>
              <DD> <B> Case label: </B> <CODE> <xsl:value-of select="UTypeDeclarator.caseLabel"/> </CODE> </DD>
            </LI>
          </xsl:for-each>
        </UL>
      </DD>
    </DL>
  </TD> </TR>
</xsl:template>


<!--==================================================================-->
<!--  Templates: Enumeration                                          -->
<!--==================================================================-->
<xsl:template name="Enumeration-Summary">
  <TR BGCOLOR="#FFFFFF">
    <TD ALIGN="CENTER" WIDTH="1%">
      <FONT SIZE="-1"> <CODE>ENUMERATION</CODE> </FONT>
    </TD>
    <TD>
      <CODE>
        <B> <A HREF="#{@xmi.id}"> <xsl:value-of select="@xmi.label"/> </A> </B>
      </CODE>
    </TD>
  </TR>
</xsl:template>

<xsl:template name="Enumeration-Details">
  <TR> <TD>
    <A NAME="{@xmi.id}"><!-- --></A>
    <FONT SIZE="-1"> <B> <I> Enumeration: </I> </B> <BR/> </FONT>
    <FONT SIZE="4"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT> <P/>
    <DL>
      <DT> <B> Members: </B> </DT>
      <DD>
        <xsl:for-each select="Enumeration.member/EnumMember">
          <xsl:sort select="@xmi.label"/>
          <DD>
            <A NAME="{@xmi.uuid}"> <xsl:value-of select="@xmi.label"/> </A>
          </DD>
        </xsl:for-each>
      </DD>
    </DL>
  </TD> </TR>
</xsl:template>


<!--==================================================================-->
<!--  Templates: Struct                                               -->
<!--==================================================================-->
<xsl:template name="Struct-Summary">
  <TR BGCOLOR="#FFFFFF">
    <TD ALIGN="CENTER" WIDTH="1%">
      <FONT SIZE="-1"> <CODE>STRUCT</CODE> </FONT>
    </TD>
      <TD>
        <CODE>
          <B> <A HREF="#{@xmi.id}"> <xsl:value-of select="@xmi.label"/> </A> </B>
        </CODE>
      </TD>
  </TR>
</xsl:template>

<xsl:template name="Struct-Details">
  <TR> <TD>
    <A NAME="{@xmi.id}"><!-- --></A>
    <xsl:sort select="@xmi.label"/>
    <FONT SIZE="-1"> <B> <I> Struct: </I> </B> <BR/> </FONT>
    <FONT SIZE="4"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT> <P/>
    <DL>
      <DT> <B> Members: </B> </DT>
      <DD>
        <UL>
          <xsl:for-each select="Struct.member/TypeDeclarator">
            <xsl:sort select="@xmi.label"/>
            <LI>
              <A NAME="{@xmi.uuid}"> <xsl:value-of select="@xmi.label"/> </A>
              <DD> <NOBR> <B> Type: </B> <CODE> <xsl:apply-templates select="TypeDeclarator.type"/> </CODE> </NOBR> </DD>
            </LI>
          </xsl:for-each>
        </UL>
      </DD>
    </DL>
  </TD> </TR>
</xsl:template>


<!--==================================================================-->
<!--  Templates: Exception                                            -->
<!--==================================================================-->
<xsl:template name="Exception-Summary">
  <TR BGCOLOR="#FFFFFF">
    <TD ALIGN="CENTER" WIDTH="1%">
      <FONT SIZE="-1"> <CODE>EXCEPTION</CODE> </FONT>
    </TD>
    <TD>
      <CODE>
        <B> <A HREF="#{@xmi.uuid}"> <xsl:value-of select="@xmi.label"/> </A> </B>
      </CODE>
    </TD>
  </TR>
</xsl:template>

<xsl:template name="Exception-Details">
  <TR> <TD>
    <A NAME="{@xmi.id}"><!-- --></A>
    <FONT SIZE="-1"> <B> <I> Exception: </I> </B> <BR/> </FONT>
    <FONT SIZE="4"> <B> <xsl:value-of select="@xmi.label"/> </B> </FONT> <P/>
    <DL>
      <DT> <B> Members: </B> </DT>
      <DD>
        <UL>
          <xsl:for-each select="Exception.member/TypeDeclarator">
            <xsl:sort select="@xmi.label"/>
            <LI>
              <A NAME="{@xmi.uuid}"> <xsl:value-of select="@xmi.label"/> </A>
              <DD> <NOBR> <B> Type: </B> <CODE> <xsl:apply-templates select="TypeDeclarator.type"/> </CODE> </NOBR> </DD>
            </LI>
          </xsl:for-each>
        </UL>
      </DD>
    </DL>
  </TD> </TR>
</xsl:template>

<!-- END -->

</xsl:stylesheet>

