/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log;

import com.ibm.ivb.log.BrowserFile;
import com.ibm.ivb.log.RecIterator;
import com.ibm.ivb.log.datamodel.AnaFileMetadata;
import com.ibm.ivb.log.datamodel.AnaRecMetadata;
import com.ibm.ivb.log.datamodel.XmlUtils;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.xml.parser.TXDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AnaFile
extends BrowserFile {
    public static final String RecIdPrefix = "Ana_";
    public static final String DTDNAME = "anadesc.dtd";
    public static String DtdDirName = null;
    public AnaFileMetadata fmd;
    public RecIterator iterator;
    String filename;

    public static String getDtdDirName() {
        return DtdDirName;
    }

    public static void setDtdDirName(String string) {
        DtdDirName = new String(string);
    }

    public AnaRecMetadata getAnaRec(String string) {
        int n = Integer.valueOf(string.substring(RecIdPrefix.length()));
        Vector vector = this.fmd.getAnaRecv();
        return (AnaRecMetadata)vector.elementAt(n);
    }

    public AnaRecMetadata getAdvAnaRec(String string) {
        int n = Integer.valueOf(string.substring(RecIdPrefix.length()));
        Vector vector = this.fmd.getAdvAnaRecv();
        return (AnaRecMetadata)vector.elementAt(n);
    }

    public AnaFileMetadata getAnaFileMetadata() {
        return this.fmd;
    }

    public void saveAsXML(String string) throws IOException {
        String string2 = new String("../dtd/anadesc.dtd");
        XmlUtils.saveAsXML(string, string2, this.fmd);
    }

    public static AnaRecMetadata processAnaRecNode(Element element) {
        AnaRecMetadata anaRecMetadata = new AnaRecMetadata();
        if (element.getAttribute("recordid") != null) {
            anaRecMetadata.setRecordId(new String(element.getAttribute("recordid")));
        }
        if (element.getAttribute("analyzername") != null) {
            anaRecMetadata.setAnalyzerName(new String(element.getAttribute("analyzername")));
        }
        if (element.getAttribute("factoryclass") != null) {
            anaRecMetadata.setFactoryClass(new String(element.getAttribute("factoryclass")));
        }
        return anaRecMetadata;
    }

    public static Vector processAnaRecvNode(Element element) {
        Vector<AnaRecMetadata> vector = null;
        int n = 0;
        int n2 = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            ++n;
            if (node.getNodeName().equalsIgnoreCase("anarec")) {
                ++n2;
                AnaRecMetadata anaRecMetadata = AnaFile.processAnaRecNode((Element)node);
                if (vector == null) {
                    vector = new Vector<AnaRecMetadata>();
                }
                vector.addElement(anaRecMetadata);
            }
            node = node.getNextSibling();
        }
        return vector;
    }

    private static AnaFileMetadata genAnaFileMetadata(TXDocument tXDocument) {
        try {
            String string;
            if (tXDocument != null && (string = tXDocument.getRootName()) != null && string.equalsIgnoreCase("anafile")) {
                AnaFileMetadata anaFileMetadata = new AnaFileMetadata();
                Element element = tXDocument.getDocumentElement();
                Node node = element.getFirstChild();
                while (node != null) {
                    Vector vector;
                    if (node.getNodeName().equalsIgnoreCase("anarecv") && (vector = AnaFile.processAnaRecvNode((Element)node)) != null) {
                        anaFileMetadata.setAnaRecv(vector);
                    }
                    if (node.getNodeName().equalsIgnoreCase("advanarecv") && (vector = AnaFile.processAnaRecvNode((Element)node)) != null) {
                        anaFileMetadata.setAdvAnaRecv(vector);
                    }
                    node = node.getNextSibling();
                }
                return anaFileMetadata;
            }
        }
        catch (Exception exception) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            String string = byteArrayOutputStream.toString();
            System.err.println(string);
            System.err.flush();
            return null;
        }
        return null;
    }

    public static void genDTD() {
        String string = new AnaFileMetadata().getClass().getName();
        String string2 = new String("../dtd/anadesc.dtd");
        XmlUtils.genDTD(string, string2);
    }

    public AnaFile(String string) throws IOException {
        if (this.fmd != null) {
            return;
        }
        if (string.endsWith(".xml")) {
            TXDocument tXDocument = BrowserFile.loadXML(string);
            if (tXDocument == null) {
                throw new IOException(String.valueOf(LogBrowser.getLBString("ComIbmIvbLogMsgCannotLoadXml")) + " " + string);
            }
            this.fmd = AnaFile.genAnaFileMetadata(tXDocument);
        }
        if (this.fmd == null) {
            throw new IOException(LogBrowser.getLBString("ComIbmIvbLogMsgAnaFileReadError"));
        }
        this.filename = new String(string);
    }

    public AnaFile(Reader reader) throws IOException {
        this.rdr = reader;
    }

    public AnaFile(AnaFileMetadata anaFileMetadata) throws IOException {
        this.fmd = anaFileMetadata;
    }

    public static void main(String[] stringArray) {
        System.out.println("generate dtd file for analyers.xml ");
        System.out.flush();
        AnaFile.genDTD();
        AnaFileMetadata anaFileMetadata = new AnaFileMetadata();
        Vector<AnaRecMetadata> vector = new Vector<AnaRecMetadata>();
        Vector<AnaRecMetadata> vector2 = new Vector<AnaRecMetadata>();
        anaFileMetadata.setAnaRecv(vector);
        anaFileMetadata.setAdvAnaRecv(vector2);
        AnaRecMetadata anaRecMetadata = new AnaRecMetadata();
        anaRecMetadata.setRecordId("Ana_0");
        anaRecMetadata.setAnalyzerName("Simple Analyzer");
        anaRecMetadata.setFactoryClass("com.ibm.ivb.log.analyzers.SimpleSeverityAnalyzer$Factory");
        vector.addElement(anaRecMetadata);
        anaRecMetadata = new AnaRecMetadata();
        anaRecMetadata.setRecordId("Ana_1");
        anaRecMetadata.setAnalyzerName("Symptom Analyzer");
        anaRecMetadata.setFactoryClass("com.ibm.ivb.log.analyzers.SymptomAnalyzer$Factory");
        vector.addElement(anaRecMetadata);
        anaRecMetadata = new AnaRecMetadata();
        anaRecMetadata.setRecordId("Ana_2");
        anaRecMetadata.setAnalyzerName("Minor Code Analyzer");
        anaRecMetadata.setFactoryClass("com.ibm.ivb.log.analyzers.MinorCodeAnalyzer$Factory");
        vector.addElement(anaRecMetadata);
        anaRecMetadata = new AnaRecMetadata();
        anaRecMetadata.setRecordId("Ana_3");
        anaRecMetadata.setAnalyzerName("OrbTrace Analyzer");
        anaRecMetadata.setFactoryClass("com.ibm.ivb.log.analyzers.OrbTraceAnalyzer$Factory");
        vector.addElement(anaRecMetadata);
        anaRecMetadata = new AnaRecMetadata();
        anaRecMetadata.setRecordId("Ana_4");
        anaRecMetadata.setAnalyzerName("Msgid Analyzer");
        anaRecMetadata.setFactoryClass("com.ibm.ivb.log.analyzers.MsgidAnalyzer$Factory");
        vector.addElement(anaRecMetadata);
        anaRecMetadata = new AnaRecMetadata();
        anaRecMetadata.setRecordId("Ana_5");
        anaRecMetadata.setAnalyzerName("GPF Analyzer");
        anaRecMetadata.setFactoryClass("com.ibm.ivb.log.analyzers.GPFAnalyzer$Factory");
        vector2.addElement(anaRecMetadata);
        try {
            AnaFile anaFile = new AnaFile(anaFileMetadata);
            System.out.println("save as XML ");
            System.out.flush();
            anaFile.saveAsXML(stringArray[0]);
            System.out.println("save as XML done ...");
            System.out.flush();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Cannot save analyzers file:");
            System.out.println(iOException.getMessage());
            System.out.flush();
            return;
        }
    }
}

