/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class NlsInputStream
extends DataInputStream {
    private byte endian;

    public NlsInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public void setEndian(byte by) {
        this.endian = by;
    }

    public NlsInputStream(InputStream inputStream, byte by) {
        super(inputStream);
        this.endian = by;
    }

    public int readNlsInt() throws IOException {
        if (this.endian != 0) {
            byte[] byArray = new byte[4];
            super.read(byArray, 0, 4);
            int n = (byArray[3] & 0xFF) * 0x1000000 + (byArray[2] & 0xFF) * 65536 + (byArray[1] & 0xFF) * 256 + (byArray[0] & 0xFF);
            return n;
        }
        return super.readInt();
    }

    public short readNlsShort() throws IOException {
        if (this.endian != 0) {
            byte[] byArray = new byte[2];
            super.read(byArray, 0, 2);
            int n = (byArray[1] & 0xFF) * 256 + (byArray[0] & 0xFF);
            return (short)n;
        }
        return super.readShort();
    }
}

