/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log;

public class Progress {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static int totalNumberOfSteps;
    private static int stepsDone;

    public static void start(int n) {
        if (n > 0) {
            totalNumberOfSteps = n;
            stepsDone = 0;
        }
    }

    public static void stop() {
        if (!Progress.isIdle()) {
            totalNumberOfSteps = 0;
            stepsDone = 0;
        }
    }

    public static void done() {
        if (!Progress.isIdle()) {
            totalNumberOfSteps = 0;
            stepsDone = 0;
        }
    }

    public static void setNumberOfStepsCompleted(int n) {
        if (!Progress.isIdle() && n > 0) {
            stepsDone = n;
            Progress.sanityCheck();
        }
    }

    public static void increment() {
        if (!Progress.isIdle()) {
            ++stepsDone;
            Progress.sanityCheck();
        }
    }

    public static int getTotalNumberOfSteps() {
        if (Progress.isIdle()) {
            return -1;
        }
        return totalNumberOfSteps;
    }

    public static int getNumberOfStepsCompleted() {
        if (Progress.isIdle()) {
            return -1;
        }
        return stepsDone;
    }

    public static int getPercentageCompleted() {
        if (Progress.isIdle()) {
            return -1;
        }
        int n = 0;
        if (totalNumberOfSteps != 0) {
            n = 100 * stepsDone / totalNumberOfSteps;
        }
        return n;
    }

    public static boolean isDone() {
        return stepsDone == totalNumberOfSteps;
    }

    public static boolean isIdle() {
        return totalNumberOfSteps == -1;
    }

    public static void setIdle() {
        totalNumberOfSteps = -1;
    }

    private static void sanityCheck() {
        if (stepsDone > totalNumberOfSteps) {
            stepsDone = totalNumberOfSteps;
        }
    }
}

