/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log;

import com.ibm.ivb.log.BrowserFile;
import com.ibm.ivb.log.RecIterator;
import com.ibm.ivb.log.datamodel.SymFileMetadata;
import com.ibm.ivb.log.datamodel.SymRecMetadata;
import com.ibm.ivb.log.datamodel.XmlUtils;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.xml.parser.TXDocument;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SymFile
extends BrowserFile {
    public static final String RecIdPrefix = "Symptom_";
    public static final String DTDNAME = "symlog.dtd";
    public static String DtdDirName = null;
    public SymFileMetadata fmd;
    public RecIterator iterator;
    String filename;
    Reader rdr;
    String mdclassname;

    public static String getDtdDirName() {
        return DtdDirName;
    }

    public static void setDtdDirName(String string) {
        DtdDirName = new String(string);
    }

    public SymRecMetadata getSymRec(String string) {
        int n = Integer.valueOf(string.substring(RecIdPrefix.length()));
        Vector vector = this.fmd.getSymRecv();
        return (SymRecMetadata)vector.elementAt(n);
    }

    public SymFileMetadata getSymFileMetadata() {
        return this.fmd;
    }

    public void saveAsXML(String string) throws IOException {
        String string2 = new String("../dtd/symlog.dtd");
        XmlUtils.saveAsXML(string, string2, this.fmd);
    }

    public static SymRecMetadata processSymRecNode(Element element) {
        SymRecMetadata symRecMetadata = new SymRecMetadata();
        if (element.getAttribute("recordid") != null) {
            symRecMetadata.setRecordId(new String(element.getAttribute("recordid")));
        }
        if (element.getAttribute("symptomstatus") != null) {
            symRecMetadata.setSymptomStatus(new String(element.getAttribute("symptomstatus")));
        }
        if (element.getAttribute("symptomtype") != null) {
            symRecMetadata.setSymptomType(new String(element.getAttribute("symptomtype")));
        }
        Node node = element.getFirstChild();
        while (node != null) {
            Vector vector;
            if (node.getNodeName().equalsIgnoreCase("matchsymptomv") && (vector = XmlUtils.processStringVecNode((Element)node)) != null) {
                symRecMetadata.setMatchSymptomv(vector);
            }
            if (node.getNodeName().equalsIgnoreCase("nomatchsymptomv") && (vector = XmlUtils.processStringVecNode((Element)node)) != null) {
                symRecMetadata.setNoMatchSymptomv(vector);
            }
            if (node.getNodeName().equalsIgnoreCase("symptominfov") && (vector = XmlUtils.processStringVecNode((Element)node)) != null) {
                symRecMetadata.setSymptomInfov(vector);
            }
            node = node.getNextSibling();
        }
        return symRecMetadata;
    }

    public static Vector processSymRecvNode(Element element) {
        Vector<SymRecMetadata> vector = null;
        int n = 0;
        int n2 = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            ++n;
            if (node.getNodeName().equalsIgnoreCase("symrec")) {
                ++n2;
                SymRecMetadata symRecMetadata = SymFile.processSymRecNode((Element)node);
                if (vector == null) {
                    vector = new Vector<SymRecMetadata>();
                }
                vector.addElement(symRecMetadata);
            }
            node = node.getNextSibling();
        }
        return vector;
    }

    private static boolean findCommentLine(String string) {
        return string.startsWith("#");
    }

    private static String findMessageSeperator(String string) {
        if (string.startsWith("-")) {
            String string2 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            stringTokenizer.nextToken();
            string2 = stringTokenizer.hasMoreTokens() ? new String(stringTokenizer.nextToken()) : "diagnosed";
            return string2;
        }
        return null;
    }

    private static boolean findMatchingString(String string, Vector vector) {
        if (string.startsWith("\"") && string.length() > 1) {
            int n = string.endsWith("\"") ? 1 : 0;
            vector.addElement(string.substring(1, string.length() - n));
            return true;
        }
        return false;
    }

    private static boolean findNoMatchString(String string, Vector vector) {
        if (string.startsWith("!\"") && string.length() > 2) {
            int n = string.endsWith("\"") ? 1 : 0;
            vector.addElement(string.substring(2, string.length() - n));
            return true;
        }
        return false;
    }

    private static void genSymRecMetadata(BufferedReader bufferedReader, Vector vector, String string) {
        SymRecMetadata symRecMetadata = null;
        String string2 = null;
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        try {
            String string3 = null;
            while (true) {
                if ((string2 = bufferedReader.readLine()) == null) {
                    return;
                }
                string3 = SymFile.findMessageSeperator(string2);
                if (string3 != null) break;
                if (SymFile.findMatchingString(string2, vector2) || SymFile.findNoMatchString(string2, vector3) || SymFile.findCommentLine(string2)) continue;
                System.out.println("Symptom File error; unparsable line:" + string2);
                System.out.flush();
            }
            if (vector2.size() != 0 || vector3.size() != 0) {
                symRecMetadata = new SymRecMetadata();
                if (vector2.size() > 0) {
                    symRecMetadata.setMatchSymptomv(vector2);
                }
                if (vector3.size() > 0) {
                    symRecMetadata.setNoMatchSymptomv(vector3);
                }
                symRecMetadata.setRecordId(RecIdPrefix + vector.size());
                symRecMetadata.setSymptomStatus(string3);
                symRecMetadata.setSymptomType(string);
                vector.addElement(symRecMetadata);
                string2 = bufferedReader.readLine();
                Vector<String> vector4 = null;
                while (string2 != null) {
                    if (vector4 == null) {
                        vector4 = new Vector<String>();
                        symRecMetadata.setSymptomInfov(vector4);
                    }
                    String string4 = XmlUtils.stripChar1a(string2);
                    vector4.addElement(string4);
                    string2 = bufferedReader.readLine();
                }
            }
            return;
        }
        catch (Exception exception) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            String string5 = byteArrayOutputStream.toString();
            System.err.println(string5);
            System.err.println(LogBrowser.getLBString("ComIbmIvbLogMsgCannotLoadSymdb"));
            System.err.flush();
            return;
        }
    }

    private static void genSymRecMetadataFromDir(String string, Vector vector) {
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            File file = null;
            File file2 = new File(string);
            String string2 = null;
            if (string.lastIndexOf("/") > 0) {
                string2 = string.substring(string.lastIndexOf("/") + 1, string.length());
            }
            String[] stringArray = file2.list();
            int n = 0;
            while (n < stringArray.length) {
                file = new File(string, stringArray[n]);
                if (file.isFile()) {
                    fileReader = new FileReader(file);
                    bufferedReader = new BufferedReader(fileReader);
                    SymFile.genSymRecMetadata(bufferedReader, vector, string2);
                }
                if (file.isDirectory()) {
                    SymFile.genSymRecMetadataFromDir(new String(String.valueOf(string) + "/" + stringArray[n]), vector);
                }
                ++n;
            }
            return;
        }
        catch (IOException iOException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            iOException.printStackTrace(printWriter);
            printWriter.flush();
            String string3 = byteArrayOutputStream.toString();
            System.err.println(string3);
            System.err.println(LogBrowser.getLBString("ComIbmIvbLogMsgCannotLoadSymdb"));
            System.err.flush();
            return;
        }
    }

    public static SymFileMetadata genSymFileMetadata(String string) {
        SymFileMetadata symFileMetadata = null;
        Vector vector = new Vector();
        try {
            SymFile.genSymRecMetadataFromDir(string, vector);
        }
        catch (Exception exception) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            String string2 = byteArrayOutputStream.toString();
            System.err.println(string2);
            System.err.println(LogBrowser.getLBString("ComIbmIvbLogMsgCannotLoadSymdb"));
            System.err.flush();
            return null;
        }
        if (vector.size() > 0) {
            symFileMetadata = new SymFileMetadata();
            symFileMetadata.setSymRecv(vector);
        }
        return symFileMetadata;
    }

    private static SymFileMetadata genSymFileMetadata(TXDocument tXDocument) {
        try {
            String string;
            if (tXDocument != null && (string = tXDocument.getRootName()) != null && string.equalsIgnoreCase("symfile")) {
                SymFileMetadata symFileMetadata = new SymFileMetadata();
                Element element = tXDocument.getDocumentElement();
                Node node = element.getFirstChild();
                while (node != null) {
                    Vector vector;
                    if (node.getNodeName().equalsIgnoreCase("symrecv") && (vector = SymFile.processSymRecvNode((Element)node)) != null) {
                        symFileMetadata.setSymRecv(vector);
                    }
                    node = node.getNextSibling();
                }
                return symFileMetadata;
            }
        }
        catch (Exception exception) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            String string = byteArrayOutputStream.toString();
            System.err.println(string);
            System.err.println(LogBrowser.getLBString("ComIbmIvbLogMsgCannotLoadSymdb"));
            System.err.flush();
            return null;
        }
        return null;
    }

    public static void genDTD() {
        String string = new SymFileMetadata().getClass().getName();
        String string2 = new String("../dtd/symlog.dtd");
        XmlUtils.genDTD(string, string2);
    }

    public SymFile(String string) throws IOException {
        if (this.fmd != null) {
            return;
        }
        if (string.endsWith(".xml")) {
            TXDocument tXDocument = BrowserFile.loadXML(string);
            if (tXDocument == null) {
                throw new IOException(new String(LogBrowser.getLBString("ComIbmIvbLogMsgCannotLoadXml " + string)));
            }
            this.fmd = SymFile.genSymFileMetadata(tXDocument);
        } else {
            File file = new File(string);
            if (file.isDirectory()) {
                this.fmd = SymFile.genSymFileMetadata(string);
            }
        }
        if (this.fmd == null) {
            throw new IOException(LogBrowser.getLBString("ComIbmIvbLogMsgSymFileReadError"));
        }
        this.filename = new String(string);
    }

    public SymFile(Reader reader) throws IOException {
        this.rdr = reader;
    }

    public static void main(String[] stringArray) {
        if (Array.getLength(stringArray) != 2) {
            System.err.println(LogBrowser.getLBString("ComIbmIvbLogMsgInvNoParam"));
            System.err.flush();
            return;
        }
        String string = System.getProperty("CURRDIR", ".");
        String string2 = null;
        String string3 = null;
        File file = new File(stringArray[0]);
        string2 = file.isAbsolute() ? stringArray[0] : String.valueOf(string) + File.separator + stringArray[0];
        file = new File(stringArray[1]);
        string3 = file.isAbsolute() ? stringArray[1] : String.valueOf(string) + File.separator + stringArray[1];
        System.out.println(String.valueOf(LogBrowser.getLBString("ComIbmIvbLogMsgGenSymdb")) + " " + string2);
        System.out.flush();
        SymFile symFile = null;
        try {
            symFile = new SymFile(string2);
            symFile.saveAsXML(string3);
        }
        catch (IOException iOException) {
            System.err.println(LogBrowser.getLBString("ComIbmIvbLogMsgCannotLoadSymdb"));
            System.err.println(iOException.getMessage());
            System.err.flush();
            System.exit(1);
        }
        System.exit(0);
    }
}

