/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.analyzers;

import com.ibm.ivb.log.Analyzer;
import com.ibm.ivb.log.AppModel;
import com.ibm.ivb.log.Record;
import com.ibm.ivb.log.datamodel.LogRecMetadata;
import java.text.SimpleDateFormat;

public class MinorCodeAnalyzer
implements Analyzer {
    private String helpdir;
    private String analyzerName;
    private static String MinorCodeUrlPrefix = null;

    public void setParameter(String string) {
        this.helpdir = new String(string);
    }

    public MinorCodeAnalyzer(String string, String string2) {
        MinorCodeUrlPrefix = string2;
        this.analyzerName = string;
    }

    public void setAnalyzerName(String string) {
        this.analyzerName = new String(string);
    }

    public void analyze(Record record) {
        if (record.getSeverity() != 1) {
            record.setAnalysisResults(this.analyzerName, "");
        }
        LogRecMetadata logRecMetadata = (LogRecMetadata)record.getRecordMetadata();
        String string = null;
        string = logRecMetadata.getPrimMsgMinorCode();
        if (string != null) {
            if (string.equals("")) {
                record.setAnalysisResults(this.analyzerName, "");
                return;
            }
            record.setStatus(Record.Status.diagnosed);
            record.setAnalysisResults(this.analyzerName, String.valueOf(MinorCodeUrlPrefix) + string);
            return;
        }
        String string2 = logRecMetadata.getPrimaryMessage();
        int n = (string2 = String.valueOf(string2) + logRecMetadata.getPrimaryMessagev().toString()).indexOf("0x4942");
        if (n != -1) {
            string = new String(string2.substring(n + 2, n + 10));
            logRecMetadata.setPrimMsgMinorCode(string);
            record.setStatus(Record.Status.diagnosed);
            record.setAnalysisResults(this.analyzerName, String.valueOf(MinorCodeUrlPrefix) + string);
            return;
        }
        record.setAnalysisResults(this.analyzerName, "");
        logRecMetadata.setPrimMsgMinorCode("");
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("com.ibm.CORBA.log.TimeStampFormat", "M/d/yy H:mm:ss.");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        AppModel.setTimeStampFormat(simpleDateFormat);
        System.out.println("MinorCodeAnalyzer:: main");
        System.out.flush();
        System.out.println(" done ...");
        System.out.flush();
    }

    public static class Factory
    implements Analyzer.Factory {
        private String urlprefix = "doc/lb/probdet/ref/rpxaaexe.htm#";
        private String analyzerName;

        public void setAnalyzerName(String string) {
            this.analyzerName = new String(string);
        }

        public Analyzer make() {
            return new MinorCodeAnalyzer(this.analyzerName, this.urlprefix);
        }
    }
}

