/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.analyzers;

import com.ibm.ivb.log.Analyzer;
import com.ibm.ivb.log.AppModel;
import com.ibm.ivb.log.Record;
import com.ibm.ivb.log.datamodel.LogRecMetadata;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;

public class MsgidAnalyzer
implements Analyzer {
    private String analyzerName;
    private static String MsgidUrlPrefix = null;

    public void setParameter(String string) {
        MsgidUrlPrefix = new String(string);
    }

    public MsgidAnalyzer(String string, String string2) {
        MsgidUrlPrefix = string2;
        this.analyzerName = string;
    }

    public void setAnalyzerName(String string) {
        this.analyzerName = new String(string);
    }

    private String parseMsgRef(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        int n = 0;
        while (stringTokenizer.hasMoreTokens() && n < 2) {
            string2 = stringTokenizer.nextToken();
            if (string2.endsWith(":") && string2.length() == 9) {
                try {
                    Integer.parseInt(string2.substring(4, 8));
                    return string2.substring(0, 8);
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        return null;
    }

    public void analyze(Record record) {
        LogRecMetadata logRecMetadata = (LogRecMetadata)record.getRecordMetadata();
        String string = null;
        string = logRecMetadata.getExtMsgRef();
        if (string != null) {
            if (string.equals("")) {
                record.setAnalysisResults(this.analyzerName, "");
                return;
            }
            record.setStatus(Record.Status.diagnosed);
            record.setAnalysisResults(this.analyzerName, String.valueOf(MsgidUrlPrefix) + string);
            return;
        }
        String string2 = logRecMetadata.getExtendedMessage();
        string = this.parseMsgRef(string2);
        if (string == null) {
            record.setAnalysisResults(this.analyzerName, "");
            logRecMetadata.setExtMsgRef("");
            return;
        }
        logRecMetadata.setExtMsgRef(new String(string));
        record.setStatus(Record.Status.diagnosed);
        record.setAnalysisResults(this.analyzerName, String.valueOf(MsgidUrlPrefix) + string);
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("TimeStampFormat", "M/d/yy H:mm:ss.");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        AppModel.setTimeStampFormat(simpleDateFormat);
        System.out.println("MsgidAnalyzer:: main");
        System.out.flush();
        System.out.println(" done ...");
        System.out.flush();
    }

    public static class Factory
    implements Analyzer.Factory {
        private String urlprefix = "doc/lb/probdet/ref/rpxjorbm.htm#";
        private String analyzerName;

        public void setAnalyzerName(String string) {
            this.analyzerName = new String(string);
        }

        public Analyzer make() {
            return new MsgidAnalyzer(this.analyzerName, this.urlprefix);
        }
    }
}

