/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.analyzers;

import com.ibm.CBUtils.IIOPInputStream;
import com.ibm.CBUtils.SysOut;
import com.ibm.ivb.log.Analyzer;
import com.ibm.ivb.log.AppModel;
import com.ibm.ivb.log.Record;
import com.ibm.ivb.log.datamodel.LogRecMetadata;
import com.ibm.ivb.log.datamodel.XmlUtils;
import com.ibm.ivb.log.ui.LogBrowser;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class OrbTraceAnalyzer
implements Analyzer {
    private String analyzerName;

    public void setParameter(String string) {
    }

    public OrbTraceAnalyzer(String string) {
        this.analyzerName = string;
    }

    public void setAnalyzerName(String string) {
        this.analyzerName = new String(string);
    }

    private static byte[] parseGIOPString(Vector vector, int n) {
        if (vector == null) {
            return null;
        }
        String string = (String)vector.elementAt(0);
        if (string.lastIndexOf("GIOP") == -1) {
            return null;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n3 = 0;
            String string2 = null;
            while (stringTokenizer.hasMoreTokens() && n3 < 18) {
                string2 = stringTokenizer.nextToken();
                if (n3 != 0 && n3 != 9) {
                    byArray[n2] = Integer.valueOf(string2, 16).byteValue();
                    if (++n2 == n) {
                        return byArray;
                    }
                }
                ++n3;
            }
        }
        if (n2 < n) {
            System.err.println(LogBrowser.getLBString("ComIbmIvbLogMsgGIOPShortBuf"));
            System.err.flush();
        }
        return byArray;
    }

    public void analyze(Record record) {
        String string = "";
        int n = 0;
        LogRecMetadata logRecMetadata = (LogRecMetadata)record.getRecordMetadata();
        if (logRecMetadata.getOrbTraceStatus() != null) {
            if (logRecMetadata.getOrbTraceStatus().equals("diagnosed")) {
                record.setStatus(Record.Status.diagnosed);
                string = XmlUtils.StringVecToText(logRecMetadata.getOrbTraceDatav());
            }
            record.setAnalysisResults(this.analyzerName, string);
            return;
        }
        String string2 = logRecMetadata.getRawDataLen();
        if (string2 != null) {
            try {
                byte[] byArray;
                n = Integer.parseInt(string2);
                if (n > 0 && (byArray = OrbTraceAnalyzer.parseGIOPString(logRecMetadata.getRawDatav(), n)) != null) {
                    IIOPInputStream iIOPInputStream = new IIOPInputStream();
                    try {
                        SysOut.flush();
                        iIOPInputStream.prefill(byArray);
                        string = SysOut.getString();
                        record.setStatus(Record.Status.diagnosed);
                        record.setAnalysisResults(this.analyzerName, string);
                        logRecMetadata.setOrbTraceStatus("diagnosed");
                        logRecMetadata.setOrbTraceDatav(XmlUtils.TextToStringVec(string));
                        SysOut.flush();
                        return;
                    }
                    catch (Exception exception) {
                        System.err.println(String.valueOf(LogBrowser.getLBString("ComIbmIvbLogMsgGIOPPrefillExcep")) + " " + exception);
                        System.err.flush();
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(LogBrowser.getLBString("ComIbmIvbLogMsgGIOPInvalDatalen"));
                System.err.flush();
            }
        }
        record.setAnalysisResults(this.analyzerName, "");
        logRecMetadata.setOrbTraceStatus("nothing");
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("TimeStampFormat", "M/d/yy H:mm:ss.");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        AppModel.setTimeStampFormat(simpleDateFormat);
        System.out.println("MsgidAnalyzer:: main");
        System.out.flush();
        System.out.println(" done ...");
        System.out.flush();
    }

    public static class Factory
    implements Analyzer.Factory {
        private String analyzerName;

        public void setAnalyzerName(String string) {
            this.analyzerName = new String(string);
        }

        public Analyzer make() {
            return new OrbTraceAnalyzer(this.analyzerName);
        }
    }
}

