/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.tree;

import com.ibm.ivb.log.tree.Visitor;
import java.io.IOException;

public abstract class Node {
    private int index;
    private long timeStamp = Long.MAX_VALUE;

    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public int getChildCount() {
        return 0;
    }

    public Node getChild(int n) {
        return null;
    }

    public int getIndexOfChild(Object object) {
        return -1;
    }

    public boolean isLeaf() {
        return true;
    }

    public void setTimeStamp(long l) {
        this.timeStamp = l;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public abstract boolean isSortLower(Node var1);

    public abstract void visit(Visitor var1);

    public abstract void analyze();

    public abstract void advanceAnalyze(String var1, String var2);

    public abstract void resetAdvanceAnalyze();

    public abstract void resetAnalyze();

    public abstract boolean isAnalysisDone();

    public abstract boolean isAdvanceAnalysisDone();

    public static boolean isAnalysisDone(Node[] nodeArray) {
        boolean bl = true;
        int n = 0;
        while (bl && n < nodeArray.length) {
            bl = nodeArray[n].isAnalysisDone();
            ++n;
        }
        return bl;
    }

    public static boolean isAdvanceAnalysisDone(Node[] nodeArray) {
        boolean bl = true;
        int n = 0;
        while (bl && n < nodeArray.length) {
            bl = nodeArray[n].isAdvanceAnalysisDone();
            ++n;
        }
        return bl;
    }

    public abstract String getText();

    public abstract String getAnalysisResult(String var1);

    public abstract void save(String var1, String var2) throws IOException;
}

