/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.Tool;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.ivb.log.ui.PrintExecution;
import com.ibm.ivb.log.ui.ProgressiveAction;
import com.ibm.ivb.log.ui.ProgressiveExecution;
import com.ibm.ivb.log.ui.TranslatableConstants;
import java.awt.Font;
import java.awt.Frame;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.util.Properties;

public abstract class AbstractPrintAction
extends ProgressiveAction
implements TranslatableConstants {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected static Font font;
    protected static int topMargin;
    protected static int leftMargin;
    private PrintJob pj;
    private String text;

    protected AbstractPrintAction(Tool tool) {
        super(tool.getParentFrame(), LogBrowser.getLBString("ComIbmIvbLogUiStatusPrinting"));
        this.setTool(tool);
        this.setupFont();
        this.setupMargin();
    }

    protected boolean actionPreparation() {
        this.setParentFrame(this.getTool().getParentFrame());
        boolean bl = false;
        if (this.frame != null) {
            this.pj = Toolkit.getDefaultToolkit().getPrintJob((Frame)this.frame, this.getTool().getTitle(), (Properties)this.frame.getApplication().getProfile());
            if (this.pj != null) {
                this.text = this.getTextToPrint();
                bl = true;
            }
        }
        if (!bl) {
            Toolkit.getDefaultToolkit().beep();
        }
        return bl;
    }

    protected ProgressiveExecution getProgressiveExecution() {
        return new PrintExecution(this.frame, this.pj, this.text, topMargin, font, leftMargin);
    }

    protected abstract String getTextToPrint();

    protected void setupFont() {
        font = new Font("Courier", 0, 10);
    }

    protected void setupMargin() {
        int n;
        topMargin = n = Toolkit.getDefaultToolkit().getScreenResolution();
        leftMargin = n / 2;
    }
}

